/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm.tomcat.ssl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import utils.crypto.sm.GmSSLProvider;
import utils.crypto.sm.tomcat.ssl.GMSupport;
import utils.crypto.sm.tomcat.ssl.GMUtil;

public class GMJSSEImplementation
extends JSSEImplementation {
    private static final String GM_PROTOCOL = GmSSLProvider.GMTLS;
    private static final String SEPARATOR = ":|,| ";
    private static final String HIGH = "HIGH";
    private static final String EXCLUDE = "!";
    private static final String DELETE = "-";
    private static final String ALL = "ALL";
    private static final Set<String> GM_CIPHERS_NAME_SET = new HashSet<String>();
    private static final Map<String, List<String>> ALIAS_MAP = new HashMap<String, List<String>>();
    private Set<String> explicitlyRequestedProtocols;

    private static void initGMCiphersNameSetAndAliasMap() {
        GMCipher[] gmCiphers;
        for (GMCipher gmCipher : gmCiphers = GMCipher.values()) {
            GM_CIPHERS_NAME_SET.add(gmCipher.cipherName);
            List aliasCiphers = ALIAS_MAP.computeIfAbsent(gmCipher.cipherName, k -> new ArrayList());
            aliasCiphers.add(gmCipher.cipherName);
            if (!gmCipher.aliasCipherName.isEmpty()) {
                aliasCiphers = ALIAS_MAP.computeIfAbsent(gmCipher.aliasCipherName, k -> new ArrayList());
                aliasCiphers.add(gmCipher.cipherName);
            }
            aliasCiphers = ALIAS_MAP.computeIfAbsent(gmCipher.cipherGroup.name(), k -> new ArrayList());
            aliasCiphers.add(gmCipher.cipherName);
        }
    }

    public SSLUtil getSSLUtil(SSLHostConfigCertificate certificate) {
        return new GMUtil(certificate);
    }

    public SSLSupport getSSLSupport(SSLSession session) {
        return new GMSupport(session);
    }

    private void initGMProtocol(SSLHostConfig sslHostConfig) {
        if (this.needAddGMProtocol(sslHostConfig)) {
            sslHostConfig.getProtocols().add(GM_PROTOCOL);
        }
    }

    private Set<String> getExplicitlyRequestedProtocol(SSLHostConfig sslHostConfig) {
        if (this.explicitlyRequestedProtocols != null) {
            return this.explicitlyRequestedProtocols;
        }
        try {
            Field field = sslHostConfig.getClass().getDeclaredField("explicitlyRequestedProtocols");
            field.setAccessible(true);
            this.explicitlyRequestedProtocols = (Set)field.get(sslHostConfig);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            this.explicitlyRequestedProtocols = new HashSet<String>();
        }
        return this.explicitlyRequestedProtocols;
    }

    private boolean needAddGMProtocol(SSLHostConfig sslHostConfig) {
        Set<String> explicitlyRequestedProtocol = this.getExplicitlyRequestedProtocol(sslHostConfig);
        return explicitlyRequestedProtocol.isEmpty();
    }

    private void initGMCipherSuites(SSLHostConfig sslHostConfig) {
        String ciphers = sslHostConfig.getCiphers();
        Set<String> gmCiphers = this.parseCiphers(ciphers);
        sslHostConfig.getJsseCipherNames().addAll(gmCiphers);
    }

    private Set<String> parseCiphers(String expression) {
        String[] elements = expression.split(SEPARATOR);
        HashSet<String> gmCiphers = new HashSet<String>();
        HashSet<String> removedCiphers = new HashSet<String>();
        for (String element : elements) {
            this.parseCipher(element, gmCiphers, removedCiphers);
        }
        gmCiphers.removeAll(removedCiphers);
        return gmCiphers;
    }

    private void parseCipher(String element, Set<String> gmCiphers, Set<String> removedCiphers) {
        String alias;
        if (ALIAS_MAP.containsKey(element)) {
            List<String> aliasCiphers = ALIAS_MAP.get(element);
            gmCiphers.addAll(aliasCiphers);
        } else if (element.equals(HIGH) || element.equals(ALL)) {
            gmCiphers.addAll(GM_CIPHERS_NAME_SET);
        } else if (element.startsWith(DELETE)) {
            String alias2 = element.substring(1);
            if (ALIAS_MAP.containsKey(alias2)) {
                List<String> aliasCiphers = ALIAS_MAP.get(alias2);
                aliasCiphers.forEach(gmCiphers::remove);
            }
        } else if (element.startsWith(EXCLUDE) && ALIAS_MAP.containsKey(alias = element.substring(1))) {
            List<String> aliasCiphers = ALIAS_MAP.get(alias);
            removedCiphers.addAll(aliasCiphers);
        }
    }

    static {
        GMJSSEImplementation.initGMCiphersNameSetAndAliasMap();
    }

    static enum GMCipher {
        ECC_SM4_CBC_SM3("ECC_SM4_CBC_SM3", "ECC_SM4_SM3", GMCipherGroup.GM_ECC),
        ECDHE_SM4_CBC_SM3("ECDHE_SM4_CBC_SM3", "ECDHE_SM4_SM3", GMCipherGroup.GM_ECDHE),
        ECC_SM4_GCM_SM3("ECC_SM4_GCM_SM3", GMCipherGroup.GM_ECC),
        ECDHE_SM4_GCM_SM3("ECDHE_SM4_GCM_SM3", GMCipherGroup.GM_ECDHE);

        final String cipherName;
        final String aliasCipherName;
        final GMCipherGroup cipherGroup;

        private GMCipher(String cipherName, GMCipherGroup cipherGroup) {
            this(cipherName, "", cipherGroup);
        }

        private GMCipher(String cipherName, String aliasCipherName, GMCipherGroup cipherGroup) {
            this.cipherName = cipherName;
            this.aliasCipherName = aliasCipherName;
            this.cipherGroup = cipherGroup;
        }
    }

    static enum GMCipherGroup {
        GM_ECC,
        GM_ECDHE;

    }
}

