/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm;

import org.bouncycastle.crypto.digests.SM3Digest;
import utils.security.Hasher;

public class SM3Utils {
    public static final int SM3DIGEST_LENGTH = 32;

    public static byte[] hash(byte[] data) {
        byte[] result = new byte[32];
        SM3Digest sm3digest = new SM3Digest();
        sm3digest.update(data, 0, data.length);
        sm3digest.doFinal(result, 0);
        return result;
    }

    public static byte[] hash(byte[] data, int offset, int len) {
        byte[] result = new byte[32];
        SM3Digest sm3digest = new SM3Digest();
        sm3digest.update(data, offset, len);
        sm3digest.doFinal(result, 0);
        return result;
    }

    public static Hasher beginHash() {
        return new SM3Hasher();
    }

    private static class SM3Hasher
    implements Hasher {
        private SM3Digest digest = new SM3Digest();

        private SM3Hasher() {
        }

        public void update(byte[] bytes) {
            this.digest.update(bytes, 0, bytes.length);
        }

        public void update(byte[] bytes, int offset, int len) {
            this.digest.update(bytes, offset, len);
        }

        public byte[] complete() {
            byte[] result = new byte[32];
            this.digest.doFinal(result, 0);
            return result;
        }
    }
}

