/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import utils.io.BytesUtils;
import utils.security.DecryptionException;
import utils.security.EncryptionException;
import utils.security.SignatureException;

public class SM2Utils {
    public static final int PRIVKEY_SIZE = 32;
    public static final int COORDS_SIZE = 32;
    public static final int POINT_SIZE = 65;
    public static final int R_SIZE = 32;
    public static final int S_SIZE = 32;
    public static final int SM3DIGEST_LENGTH = 32;
    private static final ECNamedCurveParameterSpec PARAMS = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
    private static final ECCurve CURVE = PARAMS.getCurve();
    public static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters(CURVE, PARAMS.getG(), PARAMS.getN(), PARAMS.getH());

    public static AsymmetricCipherKeyPair generateKeyPair() {
        SecureRandom random = new SecureRandom();
        return SM2Utils.generateKeyPair(random);
    }

    public static AsymmetricCipherKeyPair generateKeyPair(SecureRandom random) {
        ECKeyGenerationParameters keyGenerationParams = new ECKeyGenerationParameters(DOMAIN_PARAMS, random);
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init((KeyGenerationParameters)keyGenerationParams);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] pubKey2Bytes_RawKey(ECPublicKeyParameters pubKey) {
        byte[] pubKeyBytes = pubKey.getQ().getEncoded(false);
        return pubKeyBytes;
    }

    public static byte[] privKey2Bytes_RawKey(ECPrivateKeyParameters privKey) {
        byte[] privKeyBytesD = privKey.getD().toByteArray();
        byte[] privKeyBytes = new byte[32];
        if (privKeyBytesD.length > 32) {
            System.arraycopy(privKeyBytesD, privKeyBytesD.length - 32, privKeyBytes, 0, 32);
        } else {
            System.arraycopy(privKeyBytesD, 0, privKeyBytes, 32 - privKeyBytesD.length, privKeyBytesD.length);
        }
        return privKeyBytes;
    }

    public static byte[] retrievePublicKey(byte[] privateKey) {
        ECPoint publicKeyPoint = DOMAIN_PARAMS.getG().multiply(new BigInteger(1, privateKey)).normalize();
        return publicKeyPoint.getEncoded(false);
    }

    public static byte[] sign(byte[] data, byte[] privateKey) {
        SecureRandom random = new SecureRandom();
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)privKey, random);
        return SM2Utils.sign(data, (CipherParameters)params);
    }

    public static byte[] sign(byte[] data, byte[] privateKey, SecureRandom random, String ID) {
        return SM2Utils.sign(data, privateKey, random, BytesUtils.toBytes((String)ID));
    }

    public static byte[] sign(byte[] data, byte[] privateKey, byte[] ID) {
        return SM2Utils.sign(data, privateKey, new SecureRandom(), ID);
    }

    public static byte[] sign(byte[] data, int offset, int length, byte[] privateKey, byte[] ID) {
        return SM2Utils.sign(data, offset, length, privateKey, new SecureRandom(), ID);
    }

    public static byte[] sign(byte[] data, byte[] privateKey, SecureRandom random, byte[] ID) {
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        ParametersWithID params = new ParametersWithID((CipherParameters)new ParametersWithRandom((CipherParameters)privKey, random), ID);
        return SM2Utils.sign(data, 0, data.length, (CipherParameters)params);
    }

    public static byte[] sign(byte[] data, int offset, int length, byte[] privateKey, SecureRandom random, byte[] ID) {
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        ParametersWithID params = new ParametersWithID((CipherParameters)new ParametersWithRandom((CipherParameters)privKey, random), ID);
        return SM2Utils.sign(data, offset, length, (CipherParameters)params);
    }

    public static byte[] sign(byte[] data, CipherParameters params) {
        return SM2Utils.sign(data, 0, data.length, params);
    }

    public static byte[] sign(byte[] data, int offset, int length, CipherParameters params) {
        byte[] encodedSignature;
        SM2Signer signer = new SM2Signer();
        signer.init(true, params);
        signer.update(data, offset, length);
        try {
            encodedSignature = signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.getMessage(), (Throwable)e);
        }
        ASN1Sequence sig = ASN1Sequence.getInstance((Object)encodedSignature);
        byte[] rBytes = SM2Utils.trimBigIntegerTo32Bytes(ASN1Integer.getInstance((Object)sig.getObjectAt(0)).getValue());
        byte[] sBytes = SM2Utils.trimBigIntegerTo32Bytes(ASN1Integer.getInstance((Object)sig.getObjectAt(1)).getValue());
        byte[] signature = new byte[64];
        System.arraycopy(rBytes, 0, signature, 0, 32);
        System.arraycopy(sBytes, 0, signature, 32, 32);
        return signature;
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature) {
        ECPoint pubKeyPoint = SM2Utils.resolvePubKeyBytes(publicKey);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(pubKeyPoint, DOMAIN_PARAMS);
        return SM2Utils.verify(data, (CipherParameters)pubKey, signature);
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature, String ID) {
        return SM2Utils.verify(data, 0, data.length, publicKey, signature, BytesUtils.toBytes((String)ID));
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signature, byte[] ID) {
        return SM2Utils.verify(data, 0, data.length, publicKey, signature, ID);
    }

    public static boolean verify(byte[] data, int offset, int length, byte[] publicKey, byte[] signature, byte[] ID) {
        ECPoint pubKeyPoint = SM2Utils.resolvePubKeyBytes(publicKey);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(pubKeyPoint, DOMAIN_PARAMS);
        ParametersWithID params = new ParametersWithID((CipherParameters)pubKey, ID);
        return SM2Utils.verify(data, (CipherParameters)params, signature);
    }

    public static boolean verify(byte[] data, CipherParameters params, byte[] signature) {
        return SM2Utils.verify(data, 0, data.length, params, signature);
    }

    public static boolean verify(byte[] data, int offset, int length, CipherParameters params, byte[] signature) {
        SM2Signer verifier = new SM2Signer();
        verifier.init(false, params);
        verifier.update(data, offset, length);
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        System.arraycopy(signature, 0, rBytes, 0, 32);
        System.arraycopy(signature, 32, sBytes, 0, 32);
        BigInteger r = new BigInteger(1, rBytes);
        BigInteger s = new BigInteger(1, sBytes);
        byte[] encodedSignature = new byte[]{};
        try {
            encodedSignature = new DERSequence(new ASN1Encodable[]{new ASN1Integer(r), new ASN1Integer(s)}).getEncoded();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return verifier.verifySignature(encodedSignature);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] publicKey) {
        SecureRandom random = new SecureRandom();
        return SM2Utils.encrypt(plainBytes, 0, plainBytes.length, publicKey, random);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] publicKey) {
        SecureRandom random = new SecureRandom();
        return SM2Utils.encrypt(plainBytes, offset, length, publicKey, random);
    }

    public static byte[] encrypt(byte[] plainBytes, byte[] publicKey, SecureRandom random) {
        return SM2Utils.encrypt(plainBytes, 0, plainBytes.length, publicKey, random);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, byte[] publicKey, SecureRandom random) {
        ECPoint pubKeyPoint = SM2Utils.resolvePubKeyBytes(publicKey);
        ECPublicKeyParameters pubKey = new ECPublicKeyParameters(pubKeyPoint, DOMAIN_PARAMS);
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)pubKey, random);
        return SM2Utils.encrypt(plainBytes, offset, length, (CipherParameters)params);
    }

    public static byte[] encrypt(byte[] plainBytes, ECPublicKeyParameters pubKey) {
        SecureRandom random = new SecureRandom();
        ParametersWithRandom params = new ParametersWithRandom((CipherParameters)pubKey, random);
        return SM2Utils.encrypt(plainBytes, (CipherParameters)params);
    }

    public static byte[] encrypt(byte[] plainBytes, CipherParameters params) {
        return SM2Utils.encrypt(plainBytes, 0, plainBytes.length, params);
    }

    public static byte[] encrypt(byte[] plainBytes, int offset, int length, CipherParameters params) {
        byte[] c1c2c3;
        SM2Engine encryptor = new SM2Engine();
        encryptor.init(true, params);
        try {
            c1c2c3 = encryptor.processBlock(plainBytes, offset, length);
        }
        catch (InvalidCipherTextException e) {
            throw new EncryptionException(e.getMessage(), (Throwable)e);
        }
        byte[] c1c3c2 = new byte[c1c2c3.length];
        System.arraycopy(c1c2c3, 0, c1c3c2, 0, 65);
        System.arraycopy(c1c2c3, 65, c1c3c2, 97, length);
        System.arraycopy(c1c2c3, 65 + length, c1c3c2, 65, 32);
        return c1c3c2;
    }

    public static byte[] decrypt(byte[] cipherBytes, byte[] privateKey) {
        return SM2Utils.decrypt(cipherBytes, 0, cipherBytes.length, privateKey);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, byte[] privateKey) {
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(new BigInteger(1, privateKey), DOMAIN_PARAMS);
        return SM2Utils.decrypt(cipherBytes, offset, length, (CipherParameters)privKey);
    }

    public static byte[] decrypt(byte[] cipherBytes, CipherParameters params) {
        return SM2Utils.decrypt(cipherBytes, 0, cipherBytes.length, params);
    }

    public static byte[] decrypt(byte[] cipherBytes, int offset, int length, CipherParameters params) {
        SM2Engine decryptor = new SM2Engine();
        decryptor.init(false, params);
        byte[] c1c2c3 = new byte[length];
        System.arraycopy(cipherBytes, offset, c1c2c3, 0, 65);
        System.arraycopy(cipherBytes, offset + 65, c1c2c3, length - 32, 32);
        System.arraycopy(cipherBytes, offset + 32 + 65, c1c2c3, 65, length - 32 - 65);
        try {
            return decryptor.processBlock(c1c2c3, 0, c1c2c3.length);
        }
        catch (InvalidCipherTextException e) {
            throw new DecryptionException(e.getMessage(), (Throwable)e);
        }
    }

    public static byte[] trimBigIntegerTo32Bytes(BigInteger b) {
        byte[] result;
        byte[] tmp = b.toByteArray();
        if (tmp.length > (result = new byte[32]).length) {
            System.arraycopy(tmp, tmp.length - result.length, result, 0, result.length);
        } else {
            System.arraycopy(tmp, 0, result, result.length - tmp.length, tmp.length);
        }
        return result;
    }

    private static ECPoint resolvePubKeyBytes(byte[] publicKey) {
        return CURVE.decodePoint(publicKey);
    }

    public static ECCurve getCurve() {
        return CURVE;
    }

    public static ECDomainParameters getDomainParams() {
        return DOMAIN_PARAMS;
    }
}

