/*
 * Decompiled with CFR 0.152.
 */
package utils.crypto.sm;

import java.security.Provider;
import java.security.Security;

public class GmSSLProvider {
    public static final String ECC_SM4_CBC_SM_3 = "ECC_SM4_CBC_SM3";
    public static final String[] ENABLE_CIPHERS = new String[]{"ECC_SM4_CBC_SM3"};
    public static final String[] JCE_PROVIDERS = new String[]{"org.bouncycastle.jce.provider.BouncyCastleProvider"};
    public static final String[] JSSE_PROVIDERS = new String[]{"org.openeuler.BGMProvider"};
    public static final String[] GM_PROTOCOLS = new String[]{"GMTLS"};
    protected static Provider JSSE_PROVIDER;
    protected static Provider JCE_PROVIDER;
    public static String GM_PROVIDER;
    public static String GMTLS;
    public static String[] ENABLE_PROTOCOLS;

    public static void enableGMSupport(String protocol) {
        if (GmSSLProvider.isGMSSL(protocol)) {
            GmSSLProvider.loadGMProvider();
        }
    }

    private static void loadGMProvider() {
        try {
            Security.insertProviderAt(JSSE_PROVIDER, 1);
            Security.insertProviderAt(JCE_PROVIDER, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isGMSSL(String protocol) {
        return JSSE_PROVIDER != null && JCE_PROVIDER != null && GMTLS != null && GMTLS.equals(protocol);
    }

    public static boolean supportGMSSL(String sslEnabled, String protocol) {
        return Boolean.parseBoolean(sslEnabled) && GmSSLProvider.isGMSSL(protocol);
    }

    private static Class findJSSEProvider() {
        for (String provider : JSSE_PROVIDERS) {
            try {
                return Class.forName(provider);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static Class findJCEProvider() {
        for (String provider : JCE_PROVIDERS) {
            try {
                return Class.forName(provider);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    private static String findGMProtocol(Provider jsseProvider) {
        if (jsseProvider == null) {
            return null;
        }
        for (String protocol : GM_PROTOCOLS) {
            if (!jsseProvider.containsKey(String.format("SSLContext.%s", protocol))) continue;
            return protocol;
        }
        return null;
    }

    static {
        try {
            Class jsseProviderClass = GmSSLProvider.findJSSEProvider();
            Class jceProviderClass = GmSSLProvider.findJCEProvider();
            JCE_PROVIDER = jceProviderClass != null ? (Provider)jceProviderClass.newInstance() : null;
            JSSE_PROVIDER = jsseProviderClass != null ? (Provider)jsseProviderClass.newInstance() : null;
            GM_PROVIDER = JSSE_PROVIDER != null ? JSSE_PROVIDER.getName() : null;
            GMTLS = GmSSLProvider.findGMProtocol(JSSE_PROVIDER);
            ENABLE_PROTOCOLS = new String[]{GMTLS};
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

