/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.utils.web;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.jd.httpservice.utils.web.WebResponse;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import utils.serialize.json.JSONSerializeUtils;

public class JsonWebResponseMessageConverter
extends FastJsonHttpMessageConverter {
    public JsonWebResponseMessageConverter() {
        this(false);
    }

    public JsonWebResponseMessageConverter(boolean jsonPretty) {
        if (jsonPretty) {
            this.getFastJsonConfig().setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat});
        }
    }

    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        this.getFastJsonConfig().setSerializeConfig(JSONSerializeUtils.getSerializeConfig());
        this.getFastJsonConfig().setParserConfig(JSONSerializeUtils.getParserConfig());
        if (obj instanceof WebResponse) {
            super.writeInternal(obj, outputMessage);
            return;
        }
        if (obj.getClass().isArray()) {
            Object[] objects = (Object[])obj;
            if (objects != null && objects.length > 0) {
                Object[] results = new Object[objects.length];
                for (int i = 0; i < objects.length; ++i) {
                    results[i] = objects[i];
                    if (!(objects[i] instanceof Proxy)) continue;
                    try {
                        results[i] = this.getProxyHandler(objects[i]);
                        continue;
                    }
                    catch (Exception e) {
                        super.writeInternal((Object)WebResponse.createSuccessResult(obj), outputMessage);
                        return;
                    }
                }
                super.writeInternal((Object)WebResponse.createSuccessResult(results), outputMessage);
                return;
            }
        } else if (obj instanceof Proxy) {
            try {
                Object result = this.getProxyHandler(obj);
                super.writeInternal((Object)WebResponse.createSuccessResult(result), outputMessage);
                return;
            }
            catch (Exception e) {
                super.writeInternal((Object)WebResponse.createSuccessResult(obj), outputMessage);
                return;
            }
        }
        super.writeInternal((Object)WebResponse.createSuccessResult(obj), outputMessage);
    }

    private Object getProxyHandler(Object obj) throws Exception {
        Field field = obj.getClass().getSuperclass().getDeclaredField("h");
        field.setAccessible(true);
        return field.get(obj);
    }
}

