/*
 * Decompiled with CFR 0.152.
 */
package com.jd.httpservice.utils.web;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import utils.serialize.binary.BinarySerializeUtils;

public class BinaryMessageConverter
implements HttpMessageConverter<Object> {
    public static final String CONTENT_TYPE_VALUE = "application/bin-obj";
    public static final MediaType CONTENT_TYPE = MediaType.valueOf((String)"application/bin-obj");
    private static final List<MediaType> SUPPORTED_MEDIA_TYPES = Collections.singletonList(CONTENT_TYPE);

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return CONTENT_TYPE.includes(mediaType) && (clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz) || Externalizable.class.isAssignableFrom(clazz));
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return CONTENT_TYPE.includes(mediaType) && (clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz) || Externalizable.class.isAssignableFrom(clazz));
    }

    public List<MediaType> getSupportedMediaTypes() {
        return SUPPORTED_MEDIA_TYPES;
    }

    public Object read(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        return BinarySerializeUtils.deserialize((InputStream)inputMessage.getBody());
    }

    public void write(Object t, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        BinarySerializeUtils.serialize((Object)t, (OutputStream)outputMessage.getBody());
    }
}

