/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function.utils;

public abstract class SampleExtractor {
    public abstract long extract(byte[] var1, int var2);

    public static SampleExtractor createExtractor(int bitsPerSample) {
        switch (bitsPerSample) {
            case 1: 
            case 2: 
            case 4: {
                return new SampleBitsExtractor(bitsPerSample);
            }
            case 8: 
            case 16: 
            case 24: 
            case 32: {
                return new SampleBytesExtractor(bitsPerSample);
            }
            case 12: {
                return new Sample12BitsExtractor();
            }
        }
        throw new IllegalArgumentException("bitsPerSample value must be from {1, 2, 4, 8, 12, 16, 24, 32}");
    }

    private static final class Sample12BitsExtractor
    extends SampleExtractor {
        private Sample12BitsExtractor() {
        }

        @Override
        public long extract(byte[] samples, int position) {
            int bitPos = position * 12;
            int bytePos = bitPos >> 3;
            if ((bitPos & 4) == 0) {
                return (0xFF & samples[bytePos]) << 4 | (0xF0 & samples[bytePos + 1]) >> 4;
            }
            return (0xF & samples[bytePos]) << 8 | 0xFF & samples[bytePos + 1];
        }
    }

    private static final class SampleBytesExtractor
    extends SampleExtractor {
        private final int bytesPerSample;

        public SampleBytesExtractor(int bitsPerSample) {
            this.bytesPerSample = bitsPerSample >> 3;
        }

        @Override
        public long extract(byte[] samples, int position) {
            int bytePos = position * this.bytesPerSample;
            long result = 0xFF & samples[bytePos++];
            for (int i = 1; i < this.bytesPerSample; ++i) {
                result = result << 8 | (long)(0xFF & samples[bytePos++]);
            }
            return result;
        }
    }

    private static final class SampleBitsExtractor
    extends SampleExtractor {
        private final int bitsPerSample;
        private final byte mask;

        public SampleBitsExtractor(int bitsPerSample) {
            this.bitsPerSample = bitsPerSample;
            this.mask = (byte)((1 << bitsPerSample) - 1);
        }

        @Override
        public long extract(byte[] samples, int position) {
            int bitPos = position * this.bitsPerSample;
            int bytePos = bitPos >> 3;
            int shift = 8 - (bitPos & 7) - this.bitsPerSample;
            return samples[bytePos] >> shift & this.mask;
        }
    }
}

