/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;

public class PdfEncryptedPayload
extends PdfObjectWrapper<PdfDictionary> {
    public PdfEncryptedPayload(String subtype) {
        this(new PdfDictionary());
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Type, PdfName.EncryptedPayload);
        this.setSubtype(subtype);
    }

    private PdfEncryptedPayload(PdfDictionary pdfObject) {
        super(pdfObject);
    }

    public static PdfEncryptedPayload extractFrom(PdfFileSpec fileSpec) {
        if (fileSpec != null && ((PdfObject)fileSpec.getPdfObject()).isDictionary()) {
            return PdfEncryptedPayload.wrap(((PdfDictionary)fileSpec.getPdfObject()).getAsDictionary(PdfName.EP));
        }
        return null;
    }

    public static PdfEncryptedPayload wrap(PdfDictionary dictionary) {
        PdfName type = dictionary.getAsName(PdfName.Type);
        if (type != null && !type.equals(PdfName.EncryptedPayload)) {
            throw new PdfException("Encrypted payload dictionary shall have field 'Type' equal to 'EncryptedPayload' if present");
        }
        if (dictionary.getAsName(PdfName.Subtype) == null) {
            throw new PdfException("Encrypted payload shall have 'Subtype' field specifying crypto filter");
        }
        return new PdfEncryptedPayload(dictionary);
    }

    public PdfName getSubtype() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Subtype);
    }

    public PdfEncryptedPayload setSubtype(String subtype) {
        return this.setSubtype(new PdfName(subtype));
    }

    public PdfEncryptedPayload setSubtype(PdfName subtype) {
        this.setModified();
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Subtype, subtype);
        return this;
    }

    public PdfName getVersion() {
        return ((PdfDictionary)this.getPdfObject()).getAsName(PdfName.Version);
    }

    public PdfEncryptedPayload setVersion(String version) {
        return this.setVersion(new PdfName(version));
    }

    public PdfEncryptedPayload setVersion(PdfName version) {
        this.setModified();
        ((PdfDictionary)this.getPdfObject()).put(PdfName.Version, version);
        return this;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }
}

