/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.io.font.AbstractTrueTypeFontModifier;
import com.itextpdf.io.font.OpenTypeParser;
import com.itextpdf.io.source.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class TrueTypeFontMerger
extends AbstractTrueTypeFontModifier {
    private final Map<Integer, byte[]> horizontalMetricMap;
    private final int numberOfHMetrics;

    TrueTypeFontMerger(String fontName, Map<OpenTypeParser, Set<Integer>> fontsToMerge) throws IOException {
        super(fontName, true);
        this.horizontalMetricMap = new HashMap<Integer, byte[]>(fontsToMerge.size());
        this.glyphDataMap = new HashMap(fontsToMerge.size());
        OpenTypeParser parserExample = null;
        for (Map.Entry<OpenTypeParser, Set<Integer>> entry : fontsToMerge.entrySet()) {
            OpenTypeParser parser = entry.getKey();
            List<Integer> usedGlyphs = parser.getFlatGlyphs(entry.getValue());
            for (Integer glyphObj : usedGlyphs) {
                int glyph = glyphObj;
                byte[] glyphData = parser.getGlyphDataForGid(glyph);
                if (this.glyphDataMap.containsKey(glyph) && !Arrays.equals((byte[])this.glyphDataMap.get(glyph), glyphData)) {
                    throw new com.itextpdf.io.exceptions.IOException("Incompatibility of glyph data/metrics between merged fonts").setMessageParams(fontName);
                }
                this.glyphDataMap.put(glyph, glyphData);
                byte[] glyphMetric = parser.getHorizontalMetricForGid(glyph);
                if (this.horizontalMetricMap.containsKey(glyph) && !Arrays.equals(this.horizontalMetricMap.get(glyph), glyphMetric)) {
                    throw new com.itextpdf.io.exceptions.IOException("Incompatibility of glyph data/metrics between merged fonts").setMessageParams(fontName);
                }
                this.horizontalMetricMap.put(glyph, glyphMetric);
            }
            if (parserExample != null && parser.hhea.numberOfHMetrics <= parserExample.hhea.numberOfHMetrics) continue;
            parserExample = parser;
        }
        this.raf = parserExample.raf.createView();
        this.directoryOffset = parserExample.directoryOffset;
        this.numberOfHMetrics = parserExample.hhea.numberOfHMetrics;
    }

    @Override
    protected void mergeTables() throws IOException {
        super.createNewGlyfAndLocaTables();
        this.createNewHorizontalMetricsTable();
    }

    private void createNewHorizontalMetricsTable() throws IOException {
        int[] tableLocation = (int[])this.tableDirectory.get("hmtx");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.raf.seek(tableLocation[1]);
        for (int k = 0; k < this.numberOfHMetrics; ++k) {
            if (this.horizontalMetricMap.containsKey(k)) {
                this.raf.skipBytes(4);
                baos.write(this.horizontalMetricMap.get(k));
                continue;
            }
            baos.write(this.raf.readByte());
            baos.write(this.raf.readByte());
            baos.write(this.raf.readByte());
            baos.write(this.raf.readByte());
        }
        this.modifiedTables.put("hmtx", baos.toByteArray());
    }
}

