/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.fields.ChoiceFormFieldBuilder;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.form.element.AbstractSelectField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.element.SelectFieldItem;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSelectFieldRenderer
extends BlockRenderer {
    protected AbstractSelectFieldRenderer(AbstractSelectField modelElement) {
        super((IElement)modelElement);
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        this.childRenderers.clear();
        this.addChild(this.createFlatRenderer());
        Float width = this.retrieveWidth(layoutContext.getArea().getBBox().getWidth());
        if (width != null) {
            this.updateWidth(UnitValue.createPointValue((float)width.floatValue()));
        }
        float childrenMaxWidth = this.getMinMaxWidth().getMaxWidth();
        LayoutArea area = layoutContext.getArea().clone();
        area.getBBox().moveDown(1000000.0f - area.getBBox().getHeight()).setHeight(1000000.0f).setWidth(childrenMaxWidth + 1.0E-4f);
        boolean isForcedPlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
        LayoutResult layoutResult = super.layout(new LayoutContext(area, layoutContext.getMarginsCollapseInfo(), layoutContext.getFloatRendererAreas(), layoutContext.isClippedHeight()));
        if (isForcedPlacement) {
            this.setProperty(26, true);
        }
        if (layoutResult.getStatus() != 1) {
            if (isForcedPlacement) {
                layoutResult = this.makeLayoutResultFull(layoutContext.getArea(), layoutResult);
            } else {
                return new LayoutResult(3, null, null, (IRenderer)this, (IRenderer)this);
            }
        }
        float availableHeight = layoutContext.getArea().getBBox().getHeight();
        boolean isClippedHeight = layoutContext.isClippedHeight();
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        this.applyMargins(dummy, true);
        this.applyBorderBox(dummy, true);
        this.applyPaddings(dummy, true);
        float additionalHeight = dummy.getHeight();
        availableHeight -= additionalHeight;
        availableHeight = Math.max(availableHeight, 0.0f);
        float actualHeight = this.getOccupiedArea().getBBox().getHeight() - additionalHeight;
        float finalSelectFieldHeight = this.getFinalSelectFieldHeight(availableHeight, actualHeight, isClippedHeight);
        if (finalSelectFieldHeight < 0.0f) {
            return new LayoutResult(3, null, null, (IRenderer)this, (IRenderer)this);
        }
        float delta = finalSelectFieldHeight - actualHeight;
        if (Math.abs(delta) > 1.0E-4f) {
            this.getOccupiedArea().getBBox().increaseHeight(delta).moveDown(delta);
        }
        return layoutResult;
    }

    public void draw(DrawContext drawContext) {
        if (this.isFlatten()) {
            super.draw(drawContext);
        } else {
            this.drawChildren(drawContext);
        }
    }

    public void drawChildren(DrawContext drawContext) {
        if (this.isFlatten()) {
            super.drawChildren(drawContext);
        } else {
            this.applyAcroField(drawContext);
            this.writeAcroFormFieldLangAttribute(drawContext.getDocument());
        }
    }

    protected String getLang() {
        String language = null;
        if (this.getModelElement() instanceof IAccessibleElement) {
            language = ((IAccessibleElement)this.getModelElement()).getAccessibilityProperties().getLanguage();
        }
        return language;
    }

    protected void writeAcroFormFieldLangAttribute(PdfDocument pdfDoc) {
        if (pdfDoc.isTagged()) {
            TagTreePointer formParentPointer = pdfDoc.getTagStructureContext().getAutoTaggingPointer();
            List kidsRoles = formParentPointer.getKidsRoles();
            int lastFormIndex = kidsRoles.lastIndexOf("Form");
            TagTreePointer formPointer = formParentPointer.moveToKid(lastFormIndex);
            if (this.getLang() != null) {
                formPointer.getProperties().setLanguage(this.getLang());
            }
            formParentPointer.moveToParent();
        }
    }

    protected void applyAccessibilityProperties(PdfFormField formField, PdfDocument pdfDocument) {
        if (!pdfDocument.isTagged()) {
            return;
        }
        AccessibilityProperties properties = ((IAccessibleElement)this.modelElement).getAccessibilityProperties();
        String alternativeDescription = properties.getAlternateDescription();
        if (alternativeDescription != null && !alternativeDescription.isEmpty()) {
            formField.setAlternativeName(alternativeDescription);
        }
    }

    protected abstract IRenderer createFlatRenderer();

    protected abstract void applyAcroField(DrawContext var1);

    protected boolean isFlatten() {
        return this.getPropertyAsBoolean(0x200001);
    }

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    protected void setupBuilderValues(ChoiceFormFieldBuilder builder, AbstractSelectField field) {
        List<SelectFieldItem> options = field.getOptions();
        if (options.isEmpty()) {
            builder.setOptions(new String[0]);
            return;
        }
        boolean supportExportValueAndDisplayValue = field.hasExportAndDisplayValues();
        if (supportExportValueAndDisplayValue) {
            String[][] exportValuesAndDisplayValues = new String[options.size()][];
            for (int i = 0; i < options.size(); ++i) {
                SelectFieldItem option = options.get(i);
                String[] exportValues = new String[]{option.getExportValue(), option.getDisplayValue()};
                exportValuesAndDisplayValues[i] = exportValues;
            }
            builder.setOptions(exportValuesAndDisplayValues);
        } else {
            String[] displayValues = new String[options.size()];
            for (int i = 0; i < options.size(); ++i) {
                SelectFieldItem option = options.get(i);
                displayValues[i] = option.getDisplayValue();
            }
            builder.setOptions(displayValues);
        }
    }

    protected float getFinalSelectFieldHeight(float availableHeight, float actualHeight, boolean isClippedHeight) {
        boolean isForcedPlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
        if (!isClippedHeight && actualHeight > availableHeight) {
            if (isForcedPlacement) {
                return availableHeight;
            }
            return -1.0f;
        }
        return actualHeight;
    }

    protected PdfConformance getConformance(PdfDocument document) {
        PdfConformance conformance = (PdfConformance)this.getProperty(0x20000F);
        if (conformance != null) {
            return conformance;
        }
        if (document == null) {
            return null;
        }
        return document.getConformance();
    }

    protected List<IRenderer> getOptionsMarkedSelected(IRenderer optionsSubTree) {
        ArrayList<IRenderer> selectedOptions = new ArrayList<IRenderer>();
        for (IRenderer option : optionsSubTree.getChildRenderers()) {
            if (AbstractSelectFieldRenderer.isOptionRenderer(option)) {
                if (!Boolean.TRUE.equals(option.getProperty(0x200009))) continue;
                selectedOptions.add(option);
                continue;
            }
            List<IRenderer> subSelectedOptions = this.getOptionsMarkedSelected(option);
            selectedOptions.addAll(subSelectedOptions);
        }
        return selectedOptions;
    }

    static boolean isOptGroupRenderer(IRenderer renderer) {
        return renderer.hasProperty(0x20000A) && !renderer.hasProperty(0x200009);
    }

    static boolean isOptionRenderer(IRenderer child) {
        return child.hasProperty(0x200009);
    }

    private LayoutResult makeLayoutResultFull(LayoutArea layoutArea, LayoutResult layoutResult) {
        AbstractSelectFieldRenderer splitRenderer;
        AbstractSelectFieldRenderer abstractSelectFieldRenderer = splitRenderer = layoutResult.getSplitRenderer() == null ? this : layoutResult.getSplitRenderer();
        if (this.occupiedArea == null) {
            this.occupiedArea = new LayoutArea(layoutArea.getPageNumber(), new Rectangle(layoutArea.getBBox().getLeft(), layoutArea.getBBox().getTop(), 0.0f, 0.0f));
        }
        layoutResult = new LayoutResult(1, this.occupiedArea, (IRenderer)splitRenderer, null);
        return layoutResult;
    }
}

