/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXml;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlHandler;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlWriter;
import com.ibm.db2.cmx.runtime.statement.StatementDescriptor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PDQXmlReader {
    private PDQXml pdqXML_;
    private ClassLoader classLoader_;

    public PDQXml getPDQXml() {
        return this.pdqXML_;
    }

    public void parse(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        InputSource inputSource = new InputSource(inputStream);
        PDQXmlHandler pDQXmlHandler = new PDQXmlHandler();
        sAXParser.getXMLReader().setContentHandler(pDQXmlHandler);
        sAXParser.getXMLReader().setErrorHandler(pDQXmlHandler);
        sAXParser.parse(inputSource, (DefaultHandler)null);
        this.pdqXML_ = pDQXmlHandler.getPdqXml();
    }

    public void parseFile(String string) throws Exception {
        BufferedInputStream bufferedInputStream = PDQXmlReader.getResourceOrFileAsBufferedInputStream(string);
        try {
            this.parseStream(bufferedInputStream);
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
    }

    public void parseStream(InputStream inputStream) {
        try {
            this.parse(inputStream);
        }
        catch (Exception exception) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PARSE_XML", new Object[0]), exception, 10299);
        }
    }

    public List<StatementDescriptor> getStatementDescriptorsForRuntime() {
        List<PDQXmlStatementSet> list = this.pdqXML_.getStatementSets();
        ArrayList<StatementDescriptor> arrayList = new ArrayList<StatementDescriptor>();
        for (PDQXmlStatementSet pDQXmlStatementSet : list) {
            for (PDQXmlStatement pDQXmlStatement : pDQXmlStatementSet.getStatements()) {
                arrayList.add(pDQXmlStatement.getPDQXmlStatementDescriptor().createStatementDescriptorForRuntime(this.classLoader_));
            }
        }
        return arrayList;
    }

    public List<PDQXmlStatement> getStatements() {
        List<PDQXmlStatementSet> list = this.pdqXML_.getStatementSets();
        ArrayList<PDQXmlStatement> arrayList = new ArrayList<PDQXmlStatement>();
        for (int i10 = 0; i10 < list.size(); ++i10) {
            ArrayList<PDQXmlStatement> arrayList2 = list.get(i10).getStatements();
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public StatementDescriptor createStatementDescriptorForRuntime(PDQXmlStatementDescriptor pDQXmlStatementDescriptor) {
        return pDQXmlStatementDescriptor.createStatementDescriptorForRuntime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        if (stringArray.length < 0) {
            System.out.println("XML File name is required.");
            System.exit(1);
        }
        String string = stringArray[0];
        System.out.println("Processing file " + string);
        try {
            PDQXmlReader pDQXmlReader = new PDQXmlReader();
            pDQXmlReader.parseFile(string);
            System.out.println("Number of statements found: " + pDQXmlReader.getStatements().size());
            PDQXml pDQXml = pDQXmlReader.getPDQXml();
            List<PDQXmlStatementSet> list = pDQXml.getStatementSets();
            FileOutputStream fileOutputStream = new FileOutputStream("C:\\test.xml");
            try {
                PDQXmlWriter pDQXmlWriter = new PDQXmlWriter(fileOutputStream);
                pDQXmlWriter.startDocument(pDQXml);
                for (int i10 = 0; i10 < list.size(); ++i10) {
                    PDQXmlStatementSet pDQXmlStatementSet = list.get(i10);
                    pDQXmlWriter.startStatementSet(pDQXmlStatementSet);
                    ArrayList<PDQXmlStatement> arrayList = pDQXmlStatementSet.getStatements();
                    for (int i11 = 0; i11 < arrayList.size(); ++i11) {
                        pDQXmlWriter.addStatement((PDQXmlStatement)arrayList.get(i11));
                    }
                    pDQXmlWriter.endStatementSet(pDQXmlStatementSet);
                }
                pDQXmlWriter.endDocument(pDQXml);
            }
            finally {
                fileOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader_;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader_ = classLoader;
    }

    private static BufferedInputStream getResourceOrFileAsBufferedInputStream(String string) throws Exception {
        return PDQXmlReader.getResourceOrFileAsBufferedInputStreamNonPriv(string);
    }

    private static BufferedInputStream getResourceOrFileAsBufferedInputStreamNonPriv(String string) throws FileNotFoundException {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        if (null == inputStream) {
            inputStream = new FileInputStream(string);
        }
        return new BufferedInputStream(inputStream);
    }
}

