/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.util.HashMap;
import java.util.List;
import org.beetl.sql.core.ExecuteContext;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.SqlId;
import org.beetl.sql.core.engine.SQLParameter;

public class TimeStatInterceptor
implements Interceptor {
    Filter filter = null;
    long max;

    public TimeStatInterceptor(long max) {
        this(null, max);
    }

    public TimeStatInterceptor(Filter filter, long max) {
        this.filter = filter;
        this.max = max;
    }

    @Override
    public void before(InterceptorContext ctx) {
        if (!this.include(ctx.getExecuteContext().sqlId)) {
            return;
        }
        ctx.setEnv(new HashMap<String, Object>());
        ctx.getEnv().put("stat.time", System.currentTimeMillis());
    }

    @Override
    public void after(InterceptorContext ctx) {
        long start;
        if (!this.include(ctx.getExecuteContext().sqlId)) {
            return;
        }
        long end = System.currentTimeMillis();
        if (end - (start = ((Long)ctx.get("stat.time")).longValue()) > this.max) {
            ExecuteContext executeContext = ctx.getExecuteContext();
            this.print(executeContext.sqlId.toString(), executeContext.sqlResult.jdbcSql, executeContext.sqlResult.jdbcPara, end - start);
        }
    }

    protected void print(String sqlId, String sql, List<SQLParameter> paras, long time) {
        System.out.println("sqlId=" + sqlId + " time:" + time);
        System.out.println("=====================");
        System.out.println(this.formatSql(sql));
    }

    protected boolean include(SqlId id) {
        if (this.filter == null) {
            return true;
        }
        return this.filter.isAccept(id);
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
    }

    public static interface Filter {
        public boolean isAccept(SqlId var1);
    }
}

