/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.nosql;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.sql.Connection;
import org.beetl.sql.annotation.entity.AssignID;
import org.beetl.sql.annotation.entity.AutoID;
import org.beetl.sql.annotation.entity.Column;
import org.beetl.sql.annotation.entity.SeqID;
import org.beetl.sql.annotation.entity.Table;
import org.beetl.sql.clazz.ColDesc;
import org.beetl.sql.clazz.TableDesc;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.clazz.kit.JavaType;
import org.beetl.sql.clazz.kit.ThreadSafeCaseInsensitiveHashMap;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.meta.SchemaMetadataManager;

public class SchemaLessMetaDataManager
extends SchemaMetadataManager {
    protected ThreadSafeCaseInsensitiveHashMap extClassMap = new ThreadSafeCaseInsensitiveHashMap();

    public SchemaLessMetaDataManager(ConnectionSource ds, DBStyle style) {
        super(ds, style);
    }

    public SchemaLessMetaDataManager(ConnectionSource ds, String defaultSchema, String defaultCatalog, DBStyle style) {
        super(ds, defaultSchema, defaultCatalog, style);
    }

    public void addBean(Class bean) {
        this.parseBean(bean);
    }

    @Override
    protected void moreInfo(Connection conn, TableDesc tableDesc) {
        if (!this.extClassMap.containsKey((Object)tableDesc.getName())) {
            return;
        }
        TableDesc classDesc = (TableDesc)this.extClassMap.get((Object)tableDesc.getName());
        if (tableDesc.getIdNames().isEmpty()) {
            classDesc.getIdNames().forEach(name -> tableDesc.addIdName((String)name));
        }
    }

    protected void parseBean(Class bean) {
        Table table = (Table)BeanKit.getAnnotation((Class)bean, Table.class);
        if (table == null) {
            throw new NullPointerException(bean + " \u9700\u8981\u6ce8\u89e3 @Table");
        }
        TableDesc tableDesc = new TableDesc(table.name(), bean.getName());
        try {
            PropertyDescriptor[] propertyDescriptors;
            for (PropertyDescriptor ps : propertyDescriptors = BeanKit.propertyDescriptors((Class)bean)) {
                Column column = (Column)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), Column.class);
                if (column == null) continue;
                String colName = column.value();
                Class<?> type = ps.getPropertyType();
                ColDesc colDesc = new ColDesc(colName);
                this.initSqlType(colDesc, type);
                tableDesc.addCols(colDesc);
                AssignID assignID = (AssignID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), AssignID.class);
                if (assignID != null) {
                    tableDesc.addIdName(column.value());
                    continue;
                }
                AutoID autoID = (AutoID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), AutoID.class);
                if (autoID != null) {
                    tableDesc.addIdName(column.value());
                    continue;
                }
                SeqID seqID = (SeqID)BeanKit.getAnnotation((Class)bean, (String)ps.getName(), SeqID.class);
                if (seqID == null) continue;
                tableDesc.addIdName(column.value());
            }
            this.extClassMap.put(tableDesc.getName(), (Object)tableDesc);
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
    }

    protected void initSqlType(ColDesc colDesc, Class type) {
        Integer jdbcType = (Integer)JavaType.javaTypeJdbcs.get(type);
        if (jdbcType == null) {
            throw new IllegalArgumentException("NoSchemaMetaDataManager \u4e0d\u652f\u6301\u7c7b\u578b " + type);
        }
        colDesc.setSqlType(jdbcType);
    }
}

