/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import javax.sql.DataSource;
import org.beetl.sql.core.SQLManager;

public abstract class DBRunner<T> {
    protected abstract DataSource getTargetDataSource(SQLManager var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T start(SQLManager sm) {
        try {
            T t;
            DataSource ds = this.getTargetDataSource(sm);
            sm.getDs().forceBegin(ds);
            T t2 = t = this.run(sm);
            return t2;
        }
        finally {
            sm.getDs().forceEnd();
        }
    }

    public abstract <T> T run(SQLManager var1);

    public static abstract class EachSlaveDbRunner
    extends DBRunner<Object> {
        @Override
        protected DataSource getTargetDataSource(SQLManager sqlManager) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object start(SQLManager sm) {
            try {
                DataSource[] slaves;
                for (DataSource ds : slaves = sm.getDs().getSlaves()) {
                    sm.getDs().forceBegin(ds);
                    this.run(sm);
                    sm.getDs().forceEnd();
                }
                DataSource[] dataSourceArray = null;
                return dataSourceArray;
            }
            finally {
                sm.getDs().forceEnd();
            }
        }
    }

    public static abstract class SlaveDBRunner<T>
    extends DBRunner<T> {
        @Override
        protected DataSource getTargetDataSource(SQLManager sqlManager) {
            DataSource[] ds = sqlManager.getDs().getSlaves();
            if (ds == null) {
                throw new IllegalArgumentException(" sqlManager =" + sqlManager.getName() + " \u6ca1\u6709\u4ece\u6570\u636e\u6e90");
            }
            return ds[0];
        }
    }

    public static abstract class MasterDBRunner<T>
    extends DBRunner<T> {
        @Override
        protected DataSource getTargetDataSource(SQLManager sqlManager) {
            DataSource ds = sqlManager.getDs().getMasterSource();
            return ds;
        }
    }
}

