/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.io.InputStreamWrapper;
import com.obs.services.internal.io.InterruptableInputStream;
import com.obs.shade.okhttp3.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class HttpMethodReleaseInputStream
extends InputStream
implements InputStreamWrapper {
    private static final ILogger log = LoggerBuilder.getLogger(HttpMethodReleaseInputStream.class);
    private InputStream inputStream = null;
    private Response httpResponse = null;
    private boolean flag = false;
    private boolean comsumed = false;

    public HttpMethodReleaseInputStream(Response response) {
        this.httpResponse = response;
        try {
            this.inputStream = new InterruptableInputStream(response.body().byteStream());
        }
        catch (Exception e) {
            try {
                response.close();
            }
            catch (Exception ee) {
                log.warn("io close failed.", ee);
            }
            this.inputStream = new ByteArrayInputStream(new byte[0]);
        }
    }

    public Response getHttpResponse() {
        return this.httpResponse;
    }

    protected void closeConnection() throws IOException {
        if (!this.flag) {
            if (!this.comsumed && this.httpResponse != null) {
                this.httpResponse.close();
            }
            this.flag = true;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int read = this.inputStream.read();
            if (read == -1) {
                this.comsumed = true;
                if (!this.flag) {
                    this.closeConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.closeConnection();
            }
            catch (IOException ignored) {
                log.warn("io close failed.", ignored);
            }
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int read = this.inputStream.read(b, off, len);
            if (read == -1) {
                this.comsumed = true;
                if (!this.flag) {
                    this.closeConnection();
                }
            }
            return read;
        }
        catch (IOException e) {
            try {
                this.closeConnection();
            }
            catch (IOException ignored) {
                log.warn("io close failed.", ignored);
            }
            throw e;
        }
    }

    @Override
    public int available() throws IOException {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            try {
                this.closeConnection();
            }
            catch (IOException ignored) {
                log.warn("io close failed.", ignored);
            }
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.flag) {
            this.closeConnection();
        }
        this.inputStream.close();
    }

    @Override
    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

