/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.services.internal.io.InputStreamWrapper;
import com.obs.services.internal.io.UnrecoverableIOException;
import java.io.IOException;
import java.io.InputStream;

public class InterruptableInputStream
extends InputStream
implements InputStreamWrapper {
    private InputStream inputStream = null;
    private boolean interrupted = false;

    public InterruptableInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    private void maybeInterruptInputStream() throws IOException {
        if (this.interrupted) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new UnrecoverableIOException("Reading from input stream deliberately interrupted");
        }
    }

    public int read() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.read(b, off, len);
    }

    public int available() throws IOException {
        this.maybeInterruptInputStream();
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

