/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import com.obs.log.ILogger;
import com.obs.log.Logger;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerBuilder {
    public static ILogger getLogger(String name) {
        if (GetLoggerHolder.getLoggerClass != null) {
            try {
                return new Logger(GetLoggerHolder.getLoggerClass.invoke(null, name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Logger(null);
    }

    public static ILogger getLogger(Class<?> c) {
        return LoggerBuilder.getLogger(c.getName());
    }

    static class GetLoggerHolder {
        static Class<?> logManagerClass;
        static Class<?> loggerClass;
        static Method getLoggerClass;

        GetLoggerHolder() {
        }

        static {
            try {
                logManagerClass = Class.forName("org.apache.logging.log4j.LogManager");
                loggerClass = Class.forName("org.apache.logging.log4j.Logger");
                getLoggerClass = logManagerClass.getMethod("getLogger", String.class);
            }
            catch (Exception e) {
                try {
                    loggerClass = Class.forName("org.apache.log4j.Logger");
                    getLoggerClass = loggerClass.getMethod("getLogger", String.class);
                }
                catch (Exception ex) {
                    try {
                        loggerClass = Class.forName("java.util.logging.Logger");
                        getLoggerClass = loggerClass.getMethod("getLogger", String.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

