/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.db.MVIndex;
import org.h2.mvstore.db.MVTable;
import org.h2.mvstore.db.TransactionStore;
import org.h2.mvstore.db.ValueDataType;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableFilter;
import org.h2.util.New;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;

public class MVSecondaryIndex
extends BaseIndex
implements MVIndex {
    final MVTable mvTable;
    private final int keyColumns;
    private final String mapName;
    private TransactionStore.TransactionMap<Value, Value> dataMap;

    public MVSecondaryIndex(Database database, MVTable mVTable, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.mvTable = mVTable;
        this.initBaseIndex(mVTable, n, string, indexColumnArray, indexType);
        if (!this.database.isStarting()) {
            MVSecondaryIndex.checkIndexColumnTypes(indexColumnArray);
        }
        this.keyColumns = indexColumnArray.length + 1;
        this.mapName = "index." + this.getId();
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < indexColumnArray.length; ++i) {
            nArray[i] = indexColumnArray[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(database.getCompareMode(), database, nArray);
        ValueDataType valueDataType2 = new ValueDataType(null, null, null);
        this.dataMap = this.mvTable.getTransaction(null).openMap(this.mapName, valueDataType, valueDataType2);
        if (!valueDataType.equals(this.dataMap.getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
    }

    @Override
    public void addRowsToBuffer(List<Row> list, String string) {
        MVMap<Value, Value> mVMap = this.openMap(string);
        for (Row row : list) {
            ValueArray valueArray = this.convertToKey(row);
            mVMap.put(valueArray, ValueNull.INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBufferedRows(List<String> list) {
        class Source
        implements Comparable<Source> {
            Value value;
            Iterator<Value> next;
            int sourceId;

            Source() {
            }

            @Override
            public int compareTo(Source source) {
                int n = this.value.compareTo(source.value, compareMode);
                if (n == 0) {
                    n = this.sourceId - source.sourceId;
                }
                return n;
            }
        }
        Object object;
        Object object2;
        ArrayList<String> arrayList = New.arrayList(list);
        final CompareMode compareMode = this.database.getCompareMode();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (int i = 0; i < list.size(); ++i) {
            MVMap<Value, Value> mVMap3 = this.openMap(list.get(i));
            object2 = mVMap3.keyIterator(null);
            if (!object2.hasNext()) continue;
            object = new Source();
            ((Source)object).value = (Value)object2.next();
            ((Source)object).next = object2;
            ((Source)object).sourceId = i;
            treeSet.add(object);
        }
        try {
            while (true) {
                Source source = (Source)treeSet.first();
                Value value = source.value;
                if (this.indexType.isUnique()) {
                    object2 = ((ValueArray)value).getList();
                    object2 = Arrays.copyOf(object2, ((Value[])object2).length);
                    object2[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
                    object = ValueArray.get((Value[])object2);
                    ValueArray valueArray = (ValueArray)this.dataMap.getLatestCeilingKey((Value)object);
                    if (valueArray != null) {
                        SearchRow searchRow = this.convertToSearchRow(valueArray);
                        SearchRow searchRow2 = this.convertToSearchRow((ValueArray)value);
                        if (this.compareRows(searchRow2, searchRow) == 0 && !this.containsNullAndAllowMultipleNull(searchRow)) {
                            throw this.getDuplicateKeyException(valueArray.toString());
                        }
                    }
                }
                this.dataMap.putCommitted(value, ValueNull.INSTANCE);
                object2 = source.next;
                if (!object2.hasNext()) {
                    treeSet.remove(source);
                    if (treeSet.size() != 0) continue;
                    break;
                }
                object = (Value)object2.next();
                treeSet.remove(source);
                source.value = object;
                treeSet.add(source);
            }
        }
        catch (Throwable throwable) {
            for (String string : arrayList) {
                MVMap<Value, Value> mVMap = this.openMap(string);
                mVMap.getStore().removeMap(mVMap);
            }
            throw throwable;
        }
        for (String string : arrayList) {
            object2 = this.openMap(string);
            ((MVMap)object2).getStore().removeMap((MVMap<?, ?>)object2);
        }
    }

    private MVMap<Value, Value> openMap(String string) {
        int[] nArray = new int[this.keyColumns];
        for (int i = 0; i < this.indexColumns.length; ++i) {
            nArray[i] = this.indexColumns[i].sortType;
        }
        nArray[this.keyColumns - 1] = 0;
        ValueDataType valueDataType = new ValueDataType(this.database.getCompareMode(), this.database, nArray);
        ValueDataType valueDataType2 = new ValueDataType(null, null, null);
        MVMap.Builder builder = new MVMap.Builder().keyType(valueDataType).valueType(valueDataType2);
        Object m = this.database.getMvStore().getStore().openMap(string, builder);
        if (!valueDataType.equals(((MVMap)m).getKeyType())) {
            throw DbException.throwInternalError("Incompatible key type");
        }
        return m;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void add(Session session, Row row) {
        Object object;
        Object object2;
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        ValueArray valueArray = this.convertToKey(row);
        ValueArray valueArray2 = null;
        if (this.indexType.isUnique()) {
            valueArray2 = this.convertToKey(row);
            valueArray2.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
            object2 = (ValueArray)transactionMap.getLatestCeilingKey(valueArray2);
            if (object2 != null && this.compareRows(row, (SearchRow)(object = this.convertToSearchRow((ValueArray)object2))) == 0 && !this.containsNullAndAllowMultipleNull((SearchRow)object)) {
                throw this.getDuplicateKeyException(((Value)object2).toString());
            }
        }
        try {
            transactionMap.put(valueArray, ValueNull.INSTANCE);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, illegalStateException, this.table.getName());
        }
        if (this.indexType.isUnique()) {
            SearchRow searchRow;
            object2 = transactionMap.keyIterator(valueArray2, true);
            while (object2.hasNext() && this.compareRows(row, searchRow = this.convertToSearchRow((ValueArray)(object = (ValueArray)object2.next()))) == 0) {
                if (this.containsNullAndAllowMultipleNull(searchRow) || transactionMap.isSameTransaction((Value)object)) continue;
                if (transactionMap.get((Value)object) != null) {
                    throw this.getDuplicateKeyException(((Value)object).toString());
                }
                throw DbException.get(90131, this.table.getName());
            }
        }
    }

    @Override
    public void remove(Session session, Row row) {
        ValueArray valueArray = this.convertToKey(row);
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        try {
            Value value = transactionMap.remove(valueArray);
            if (value == null) {
                throw DbException.get(90112, this.getSQL() + ": " + row.getKey());
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90131, illegalStateException, this.table.getName());
        }
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) {
        TransactionStore.TransactionMap<Value, Value> transactionMap;
        ValueArray valueArray;
        block8: {
            block9: {
                ValueArray valueArray2;
                block7: {
                    valueArray = this.convertToKey(searchRow);
                    if (valueArray != null) {
                        valueArray.getList()[this.keyColumns - 1] = ValueLong.get(Long.MIN_VALUE);
                    }
                    transactionMap = this.getMap(session);
                    if (!bl || valueArray == null) break block8;
                    int n = 1;
                    while (true) {
                        if ((valueArray2 = (ValueArray)transactionMap.relativeKey(valueArray, n)) != null) {
                            int n2;
                            Value value;
                            boolean bl2 = false;
                            for (int i = 0; i < this.keyColumns - 1 && (value = searchRow.getValue(n2 = this.columnIds[i])) != null; ++i) {
                                Value value2 = valueArray2.getList()[i];
                                if (this.database.compare(value2, value) <= 0) continue;
                                bl2 = true;
                                break;
                            }
                            if (!bl2) {
                                n += n;
                                valueArray = valueArray2;
                                continue;
                            }
                        }
                        if (n > 1) {
                            n /= 2;
                            continue;
                        }
                        if (transactionMap.get(valueArray2) != null) break block7;
                        if ((valueArray = (ValueArray)transactionMap.higherKey(valueArray)) == null) break;
                    }
                    break block9;
                }
                valueArray = valueArray2;
            }
            if (valueArray == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
        }
        return new MVStoreCursor(session, transactionMap.keyIterator(valueArray), searchRow2);
    }

    private ValueArray convertToKey(SearchRow searchRow) {
        if (searchRow == null) {
            return null;
        }
        Value[] valueArray = new Value[this.keyColumns];
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int n = column.getColumnId();
            Value value = searchRow.getValue(n);
            if (value == null) continue;
            valueArray[i] = value.convertTo(column.getType());
        }
        valueArray[this.keyColumns - 1] = ValueLong.get(searchRow.getKey());
        return ValueArray.get(valueArray);
    }

    SearchRow convertToSearchRow(ValueArray valueArray) {
        Value[] valueArray2 = valueArray.getList();
        Row row = this.mvTable.getTemplateRow();
        row.setKey(valueArray2[valueArray2.length - 1].getLong());
        Column[] columnArray = this.getColumns();
        for (int i = 0; i < valueArray2.length - 1; ++i) {
            Column column = columnArray[i];
            int n = column.getColumnId();
            Value value = valueArray2[i];
            row.setValue(n, value);
        }
        return row;
    }

    @Override
    public MVTable getTable() {
        return this.mvTable;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter tableFilter, SortOrder sortOrder) {
        try {
            return 10L * this.getCostRangeIndex(nArray, this.dataMap.sizeAsLongMax(), tableFilter, sortOrder);
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public void remove(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        if (!transactionMap.isClosed()) {
            TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
            transaction.removeMap(transactionMap);
        }
    }

    @Override
    public void truncate(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        transactionMap.clear();
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Value value;
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        Value value2 = value = bl ? transactionMap.firstKey() : transactionMap.lastKey();
        while (true) {
            if (value == null) {
                return new MVStoreCursor(session, Collections.emptyList().iterator(), null);
            }
            if (((ValueArray)value).getList()[0] != ValueNull.INSTANCE) break;
            value = bl ? transactionMap.higherKey(value) : transactionMap.lowerKey(value);
        }
        ArrayList arrayList = New.arrayList();
        arrayList.add(value);
        MVStoreCursor mVStoreCursor = new MVStoreCursor(session, arrayList.iterator(), null);
        mVStoreCursor.next();
        return mVStoreCursor;
    }

    @Override
    public boolean needRebuild() {
        try {
            return this.dataMap.sizeAsLongMax() == 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getRowCount(Session session) {
        TransactionStore.TransactionMap<Value, Value> transactionMap = this.getMap(session);
        return transactionMap.sizeAsLong();
    }

    @Override
    public long getRowCountApproximation() {
        try {
            return this.dataMap.sizeAsLongMax();
        }
        catch (IllegalStateException illegalStateException) {
            throw DbException.get(90007, illegalStateException, new String[0]);
        }
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public boolean canFindNext() {
        return true;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        return this.find(session, searchRow, true, searchRow2);
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.TransactionMap<Value, Value> getMap(Session session) {
        if (session == null) {
            return this.dataMap;
        }
        TransactionStore.Transaction transaction = this.mvTable.getTransaction(session);
        return this.dataMap.getInstance(transaction, Long.MAX_VALUE);
    }

    class MVStoreCursor
    implements Cursor {
        private final Session session;
        private final Iterator<Value> it;
        private final SearchRow last;
        private Value current;
        private SearchRow searchRow;
        private Row row;

        public MVStoreCursor(Session session, Iterator<Value> iterator, SearchRow searchRow) {
            this.session = session;
            this.it = iterator;
            this.last = searchRow;
        }

        @Override
        public Row get() {
            SearchRow searchRow;
            if (this.row == null && (searchRow = this.getSearchRow()) != null) {
                this.row = MVSecondaryIndex.this.mvTable.getRow(this.session, searchRow.getKey());
            }
            return this.row;
        }

        @Override
        public SearchRow getSearchRow() {
            if (this.searchRow == null && this.current != null) {
                this.searchRow = MVSecondaryIndex.this.convertToSearchRow((ValueArray)this.current);
            }
            return this.searchRow;
        }

        @Override
        public boolean next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            this.searchRow = null;
            if (this.current != null && this.last != null && MVSecondaryIndex.this.compareRows(this.getSearchRow(), this.last) > 0) {
                this.searchRow = null;
                this.current = null;
            }
            this.row = null;
            return this.current != null;
        }

        @Override
        public boolean previous() {
            throw DbException.getUnsupportedException("previous");
        }
    }
}

