/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class PackageSpecifierNode {
    @NotNull
    private List<String> packageNames;

    public PackageSpecifierNode(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.packageNames = packageNames;
    }

    public PackageSpecifierNode() {
        this.packageNames = Collections.emptyList();
    }

    @NotNull
    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public void setPackageNames(@NotNull List<String> packageNames) {
        if (packageNames == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.packageNames = packageNames;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        if (this.packageNames.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)"/", this.packageNames) + "/";
    }
}

