/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.Reader;
import proguard.io.DataEntryToken;
import proguard.io.DataEntryTokenType;

public class DataEntryTokenizer {
    private Reader reader;
    private StringBuffer buffer;

    public DataEntryTokenizer(Reader reader) {
        this.reader = reader;
        this.buffer = new StringBuffer();
    }

    public DataEntryToken nextToken() throws IOException {
        int i;
        StringBuffer tokenString = new StringBuffer(this.buffer.toString());
        this.buffer.setLength(0);
        while ((i = this.reader.read()) >= 0) {
            char c = (char)i;
            if (tokenString.length() == 0 || this.isJavaIdentifierChar(c) == this.isJavaIdentifierChar(tokenString.charAt(0))) {
                tokenString.append(c);
                continue;
            }
            this.buffer.append(c);
            break;
        }
        if (tokenString.length() == 0) {
            return null;
        }
        DataEntryTokenType tokenType = this.isJavaIdentifierChar(tokenString.charAt(0)) ? DataEntryTokenType.JAVA_IDENTIFIER : DataEntryTokenType.OTHER;
        return new DataEntryToken(tokenString.toString(), tokenType);
    }

    private boolean isJavaIdentifierChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '.' || c == '-';
    }
}

