/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.HashSet;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MultiMemberVisitor;

public class FunctionalInterfaceFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public FunctionalInterfaceFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        if (this.isFunctionalInterface(clazz)) {
            clazz.accept(this.classVisitor);
        }
    }

    private boolean isFunctionalInterface(Clazz clazz) {
        if ((clazz.getAccessFlags() & 0x200) == 0) {
            return false;
        }
        HashSet abstractMethods = new HashSet();
        HashSet defaultMethods = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new AllMethodVisitor(new MultiMemberVisitor(new MemberAccessFilter(1024, 0, new MemberCollector(false, true, true, abstractMethods)), new MemberAccessFilter(0, 1024, new MemberCollector(false, true, true, defaultMethods)))));
        if (abstractMethods.size() == 0) {
            return false;
        }
        abstractMethods.removeAll(defaultMethods);
        return abstractMethods.size() <= 1;
    }
}

