/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.PermittedSubclassesAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.util.Processable;

public class NestUsageMarker
implements AttributeVisitor,
ConstantVisitor,
ClassVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean attributeUsed;
    private boolean classUsed;

    public NestUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        this.attributeUsed = false;
        clazz.constantPoolEntryAccept(nestHostAttribute.u2hostClassIndex, (ConstantVisitor)this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed((Processable)nestHostAttribute);
            this.markConstant(clazz, nestHostAttribute.u2attributeNameIndex);
        }
    }

    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        this.attributeUsed = false;
        nestMembersAttribute.memberClassConstantsAccept(clazz, (ConstantVisitor)this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed((Processable)nestMembersAttribute);
            this.markConstant(clazz, nestMembersAttribute.u2attributeNameIndex);
        }
    }

    public void visitPermittedSubclassesAttribute(Clazz clazz, PermittedSubclassesAttribute permittedSubclassesAttribute) {
        this.attributeUsed = false;
        permittedSubclassesAttribute.permittedSubclassConstantsAccept(clazz, (ConstantVisitor)this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed((Processable)permittedSubclassesAttribute);
            this.markConstant(clazz, permittedSubclassesAttribute.u2attributeNameIndex);
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.classUsed = this.classUsageMarker.isUsed((Processable)classConstant);
        if (!this.classUsed) {
            this.classUsed = true;
            classConstant.referencedClassAccept((ClassVisitor)this);
            if (this.classUsed) {
                this.classUsageMarker.markAsUsed((Processable)classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
        this.attributeUsed |= this.classUsed;
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.classUsageMarker.markAsUsed((Processable)utf8Constant);
    }

    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.classUsed = this.classUsageMarker.isUsed((Processable)programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.classUsed = true;
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, (ConstantVisitor)this);
    }
}

