/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.ResponsePath;
import com.graphhopper.http.WebHelper;
import com.graphhopper.util.FinishInstruction;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RoundaboutInstruction;
import com.graphhopper.util.ViaInstruction;
import com.graphhopper.util.details.PathDetail;
import com.graphhopper.util.exceptions.ConnectionNotFoundException;
import com.graphhopper.util.exceptions.DetailedIllegalArgumentException;
import com.graphhopper.util.exceptions.DetailedRuntimeException;
import com.graphhopper.util.exceptions.PointNotFoundException;
import com.graphhopper.util.exceptions.PointOutOfBoundsException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.LineString;

public class ResponsePathDeserializer
extends JsonDeserializer<ResponsePath> {
    public ResponsePath deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return ResponsePathDeserializer.createResponsePath((ObjectMapper)p.getCodec(), (JsonNode)p.readValueAsTree(), false, true);
    }

    public static ResponsePath createResponsePath(ObjectMapper objectMapper, JsonNode path, boolean hasElevation, boolean turnDescription) {
        ResponsePath responsePath = new ResponsePath();
        responsePath.addErrors(ResponsePathDeserializer.readErrors(objectMapper, path));
        if (responsePath.hasErrors()) {
            return responsePath;
        }
        if (path.has("snapped_waypoints")) {
            JsonNode snappedWaypoints = path.get("snapped_waypoints");
            PointList snappedPoints = ResponsePathDeserializer.deserializePointList(objectMapper, snappedWaypoints, hasElevation);
            responsePath.setWaypoints(snappedPoints);
        }
        if (path.has("ascend")) {
            responsePath.setAscend(path.get("ascend").asDouble());
        }
        if (path.has("descend")) {
            responsePath.setDescend(path.get("descend").asDouble());
        }
        if (path.has("weight")) {
            responsePath.setRouteWeight(path.get("weight").asDouble());
        }
        if (path.has("description")) {
            JsonNode descriptionNode = path.get("description");
            if (descriptionNode.isArray()) {
                ArrayList<String> description = new ArrayList<String>(descriptionNode.size());
                for (JsonNode descNode : descriptionNode) {
                    description.add(descNode.asText());
                }
                responsePath.setDescription(description);
            } else {
                throw new IllegalStateException("Description has to be an array");
            }
        }
        if (path.has("points")) {
            PointList pointList = ResponsePathDeserializer.deserializePointList(objectMapper, path.get("points"), hasElevation);
            responsePath.setPoints(pointList);
            if (path.has("instructions")) {
                JsonNode instrArr = path.get("instructions");
                InstructionList il = new InstructionList(null);
                int viaCount = 1;
                for (JsonNode jsonObj : instrArr) {
                    FinishInstruction instr;
                    double instDist = jsonObj.get("distance").asDouble();
                    String text = turnDescription ? jsonObj.get("text").asText() : jsonObj.get("street_name").asText();
                    long instTime = jsonObj.get("time").asLong();
                    int sign = jsonObj.get("sign").asInt();
                    JsonNode iv = jsonObj.get("interval");
                    int from = iv.get(0).asInt();
                    int to = iv.get(1).asInt();
                    PointList instPL = new PointList(to - from, hasElevation);
                    for (int j = from; j <= to; ++j) {
                        instPL.add((PointAccess)pointList, j);
                    }
                    InstructionAnnotation ia = InstructionAnnotation.EMPTY;
                    if (jsonObj.has("annotation_importance") && jsonObj.has("annotation_text")) {
                        ia = new InstructionAnnotation(jsonObj.get("annotation_importance").asInt(), jsonObj.get("annotation_text").asText());
                    }
                    if (sign == 6 || sign == -6) {
                        RoundaboutInstruction ri = new RoundaboutInstruction(sign, text, ia, instPL);
                        if (jsonObj.has("exit_number")) {
                            ri.setExitNumber(jsonObj.get("exit_number").asInt());
                        }
                        if (jsonObj.has("exited") && jsonObj.get("exited").asBoolean()) {
                            ri.setExited();
                        }
                        if (jsonObj.has("turn_angle")) {
                            double angle = jsonObj.get("turn_angle").asDouble();
                            ri.setDirOfRotation(angle);
                            ri.setRadian((angle < 0.0 ? -Math.PI : Math.PI) - angle);
                        }
                        instr = ri;
                    } else if (sign == 5) {
                        ViaInstruction tmpInstr = new ViaInstruction(text, ia, instPL);
                        tmpInstr.setViaCount(viaCount);
                        ++viaCount;
                        instr = tmpInstr;
                    } else if (sign == 4) {
                        instr = new FinishInstruction(text, (PointAccess)instPL, 0);
                    } else {
                        instr = new Instruction(sign, text, ia, instPL);
                        if (sign == 0 && jsonObj.has("heading")) {
                            instr.setExtraInfo("heading", (Object)jsonObj.get("heading").asDouble());
                        }
                    }
                    if (turnDescription) {
                        instr.setUseRawName();
                    }
                    instr.setDistance(instDist).setTime(instTime);
                    il.add((Object)instr);
                }
                responsePath.setInstructions(il);
            }
            if (path.has("details")) {
                JsonNode details = path.get("details");
                HashMap pathDetails = new HashMap(details.size());
                Iterator detailIterator = details.fields();
                while (detailIterator.hasNext()) {
                    Map.Entry detailEntry = (Map.Entry)detailIterator.next();
                    ArrayList<PathDetail> pathDetailList = new ArrayList<PathDetail>();
                    for (JsonNode pathDetail : (JsonNode)detailEntry.getValue()) {
                        PathDetail pd = (PathDetail)objectMapper.convertValue((Object)pathDetail, PathDetail.class);
                        pathDetailList.add(pd);
                    }
                    pathDetails.put(detailEntry.getKey(), pathDetailList);
                }
                responsePath.addPathDetails(pathDetails);
            }
        }
        if (path.has("points_order")) {
            responsePath.setPointsOrder((List)objectMapper.convertValue((Object)path.get("points_order"), List.class));
        } else {
            ArrayList<Integer> list = new ArrayList<Integer>(responsePath.getWaypoints().size());
            for (int i = 0; i < responsePath.getWaypoints().size(); ++i) {
                list.add(i);
            }
            responsePath.setPointsOrder(list);
        }
        double distance = path.get("distance").asDouble();
        long time = path.get("time").asLong();
        responsePath.setDistance(distance).setTime(time);
        return responsePath;
    }

    private static PointList deserializePointList(ObjectMapper objectMapper, JsonNode jsonNode, boolean hasElevation) {
        PointList snappedPoints;
        if (jsonNode.isTextual()) {
            snappedPoints = WebHelper.decodePolyline(jsonNode.asText(), Math.max(10, jsonNode.asText().length() / 4), hasElevation);
        } else {
            LineString lineString = (LineString)objectMapper.convertValue((Object)jsonNode, LineString.class);
            snappedPoints = PointList.fromLineString((LineString)lineString);
        }
        return snappedPoints;
    }

    public static List<Throwable> readErrors(ObjectMapper objectMapper, JsonNode json) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (json.has("message")) {
            if (!json.has("hints")) {
                errors.add(new RuntimeException(json.get("message").asText()));
                return errors;
            }
        } else {
            return errors;
        }
        JsonNode errorJson = json.get("hints");
        for (JsonNode error : errorJson) {
            int pointIndex;
            String exClass = "";
            if (error.has("details")) {
                exClass = error.get("details").asText();
            }
            String exMessage = error.get("message").asText();
            if (exClass.equals(UnsupportedOperationException.class.getName())) {
                errors.add(new UnsupportedOperationException(exMessage));
                continue;
            }
            if (exClass.equals(IllegalStateException.class.getName())) {
                errors.add(new IllegalStateException(exMessage));
                continue;
            }
            if (exClass.equals(RuntimeException.class.getName())) {
                errors.add((Throwable)new DetailedRuntimeException(exMessage, ResponsePathDeserializer.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(IllegalArgumentException.class.getName())) {
                errors.add((Throwable)new DetailedIllegalArgumentException(exMessage, ResponsePathDeserializer.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(ConnectionNotFoundException.class.getName())) {
                errors.add((Throwable)new ConnectionNotFoundException(exMessage, ResponsePathDeserializer.toMap(objectMapper, error)));
                continue;
            }
            if (exClass.equals(PointNotFoundException.class.getName())) {
                pointIndex = error.get("point_index").asInt();
                errors.add((Throwable)new PointNotFoundException(exMessage, pointIndex));
                continue;
            }
            if (exClass.equals(PointOutOfBoundsException.class.getName())) {
                pointIndex = error.get("point_index").asInt();
                errors.add((Throwable)new PointOutOfBoundsException(exMessage, pointIndex));
                continue;
            }
            if (exClass.isEmpty()) {
                errors.add((Throwable)new DetailedRuntimeException(exMessage, ResponsePathDeserializer.toMap(objectMapper, error)));
                continue;
            }
            errors.add((Throwable)new DetailedRuntimeException(exClass + " " + exMessage, ResponsePathDeserializer.toMap(objectMapper, error)));
        }
        if (json.has("message") && errors.isEmpty()) {
            errors.add(new RuntimeException(json.get("message").asText()));
        }
        return errors;
    }

    private static Map<String, Object> toMap(ObjectMapper objectMapper, JsonNode object) {
        return (Map)objectMapper.convertValue((Object)object, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

