/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.graphhopper.MultiException;
import com.graphhopper.util.exceptions.GHException;
import java.io.IOException;
import java.util.List;

public class MultiExceptionSerializer
extends JsonSerializer<MultiException> {
    public void serialize(MultiException e, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<Throwable> errors = e.getErrors();
        ObjectNode json = JsonNodeFactory.instance.objectNode();
        json.put("message", MultiExceptionSerializer.getMessage(errors.get(0)));
        ArrayNode errorHintList = json.putArray("hints");
        for (Throwable t : errors) {
            ObjectNode error = errorHintList.addObject();
            error.put("message", MultiExceptionSerializer.getMessage(t));
            error.put("details", t.getClass().getName());
            if (!(t instanceof GHException)) continue;
            ((GHException)t).getDetails().forEach((arg_0, arg_1) -> ((ObjectNode)error).putPOJO(arg_0, arg_1));
        }
        jsonGenerator.writeObject((Object)json);
    }

    private static String getMessage(Throwable t) {
        if (t.getMessage() == null) {
            return t.getClass().getSimpleName();
        }
        return t.getMessage();
    }
}

