/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionAnnotation;
import com.graphhopper.util.InstructionList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class InstructionListSerializer
extends JsonSerializer<InstructionList> {
    public void serialize(InstructionList instructions, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        ArrayList instrList = new ArrayList(instructions.size());
        int pointsIndex = 0;
        for (Instruction instruction : instructions) {
            HashMap<String, Object> instrJson = new HashMap<String, Object>();
            instrList.add(instrJson);
            InstructionAnnotation ia = instruction.getAnnotation();
            String text = instruction.getTurnDescription(instructions.getTr());
            if (Helper.isEmpty((String)text)) {
                text = ia.getMessage();
            }
            instrJson.put("text", Helper.firstBig((String)text));
            if (!ia.isEmpty()) {
                instrJson.put("annotation_text", ia.getMessage());
                instrJson.put("annotation_importance", ia.getImportance());
            }
            instrJson.put("street_name", instruction.getName());
            instrJson.put("time", instruction.getTime());
            instrJson.put("distance", Helper.round((double)instruction.getDistance(), (int)3));
            instrJson.put("sign", instruction.getSign());
            instrJson.putAll(instruction.getExtraInfoJSON());
            int tmpIndex = pointsIndex + instruction.getLength();
            instrJson.put("interval", Arrays.asList(pointsIndex, tmpIndex));
            pointsIndex = tmpIndex;
        }
        jsonGenerator.writeObject(instrList);
    }
}

