/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final LinkedHashMap<TarArchiveEntry, Blob> archiveMap = new LinkedHashMap();

    private void writeEntriesAsTarArchive(OutputStream tarByteStream) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(tarByteStream, StandardCharsets.UTF_8.name());){
            tarArchiveOutputStream.setLongFileMode(3);
            for (Map.Entry<TarArchiveEntry, Blob> entry : this.archiveMap.entrySet()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry.getKey());
                entry.getValue().writeTo((OutputStream)tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addTarArchiveEntry(TarArchiveEntry entry) {
        this.archiveMap.put(entry, entry.isFile() ? Blobs.from(entry.getFile().toPath()) : Blobs.from(ignored -> {}));
    }

    public void addByteEntry(byte[] contents, String name) {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize((long)contents.length);
        this.archiveMap.put(entry, Blobs.from(outputStream -> outputStream.write(contents)));
    }

    public void addBlobEntry(Blob blob, long size, String name) {
        TarArchiveEntry entry = new TarArchiveEntry(name);
        entry.setSize(size);
        this.archiveMap.put(entry, blob);
    }

    public Blob toBlob() {
        return Blobs.from(this::writeEntriesAsTarArchive);
    }
}

