/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.BlobProgressListener;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointCaller;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryEndpointRequestProperties;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class RegistryClient {
    private final EventDispatcher eventDispatcher;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
    private final boolean allowInsecureRegistries;
    private final String userAgent;

    public static Factory factory(EventDispatcher eventDispatcher, String serverUrl, String imageName) {
        return new Factory(eventDispatcher, new RegistryEndpointRequestProperties(serverUrl, imageName));
    }

    private RegistryClient(EventDispatcher eventDispatcher, @Nullable Authorization authorization, RegistryEndpointRequestProperties registryEndpointRequestProperties, boolean allowInsecureRegistries, String userAgent) {
        this.eventDispatcher = eventDispatcher;
        this.authorization = authorization;
        this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        this.allowInsecureRegistries = allowInsecureRegistries;
        this.userAgent = userAgent;
    }

    @Nullable
    public RegistryAuthenticator getRegistryAuthenticator() throws IOException, RegistryException {
        return this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointRequestProperties));
    }

    public <T extends ManifestTemplate> T pullManifest(String imageTag, Class<T> manifestTemplateClass) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointRequestProperties, imageTag, manifestTemplateClass);
        ManifestTemplate manifestTemplate = (ManifestTemplate)this.callRegistryEndpoint(manifestPuller);
        if (manifestTemplate == null) {
            throw new IllegalStateException("ManifestPuller#handleResponse does not return null");
        }
        return (T)manifestTemplate;
    }

    public ManifestTemplate pullManifest(String imageTag) throws IOException, RegistryException {
        return this.pullManifest(imageTag, ManifestTemplate.class);
    }

    public DescriptorDigest pushManifest(BuildableManifestTemplate manifestTemplate, String imageTag) throws IOException, RegistryException {
        return (DescriptorDigest)Verify.verifyNotNull((Object)this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointRequestProperties, manifestTemplate, imageTag, this.eventDispatcher)));
    }

    @Nullable
    public BlobDescriptor checkBlob(DescriptorDigest blobDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointRequestProperties, blobDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Blob pullBlob(DescriptorDigest blobDigest, Consumer<Long> blobSizeConsumer, BlobProgressListener blobProgressListener) {
        return Blobs.from(outputStream -> {
            try {
                this.callRegistryEndpoint(new BlobPuller(this.registryEndpointRequestProperties, blobDigest, outputStream, blobSizeConsumer, blobProgressListener));
            }
            catch (RegistryException ex) {
                throw new IOException(ex);
            }
        });
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest blobDigest, Blob blob, @Nullable String sourceRepository, BlobProgressListener blobProgressListener) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String getApiRouteBase() {
        return this.registryEndpointRequestProperties.getServerUrl() + "/v2/";
    }

    @VisibleForTesting
    String getUserAgent() {
        return this.userAgent;
    }

    @Nullable
    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return new RegistryEndpointCaller<T>(this.eventDispatcher, this.userAgent, this.getApiRouteBase(), registryEndpointProvider, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries).call();
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    public static class Factory {
        private final EventDispatcher eventDispatcher;
        private final RegistryEndpointRequestProperties registryEndpointRequestProperties;
        private boolean allowInsecureRegistries = false;
        @Nullable
        private String userAgentSuffix;
        @Nullable
        private Authorization authorization;

        private Factory(EventDispatcher eventDispatcher, RegistryEndpointRequestProperties registryEndpointRequestProperties) {
            this.eventDispatcher = eventDispatcher;
            this.registryEndpointRequestProperties = registryEndpointRequestProperties;
        }

        public Factory setAllowInsecureRegistries(boolean allowInsecureRegistries) {
            this.allowInsecureRegistries = allowInsecureRegistries;
            return this;
        }

        public Factory setAuthorization(@Nullable Authorization authorization) {
            this.authorization = authorization;
            return this;
        }

        public Factory setUserAgentSuffix(@Nullable String userAgentSuffix) {
            this.userAgentSuffix = userAgentSuffix;
            return this;
        }

        public RegistryClient newRegistryClient() {
            return new RegistryClient(this.eventDispatcher, this.authorization, this.registryEndpointRequestProperties, this.allowInsecureRegistries, this.makeUserAgent());
        }

        private String makeUserAgent() {
            if (!JibSystemProperties.isUserAgentEnabled()) {
                return "";
            }
            StringBuilder userAgentBuilder = new StringBuilder();
            userAgentBuilder.append("jib");
            userAgentBuilder.append(" ").append(ProjectInfo.VERSION);
            if (this.userAgentSuffix != null) {
                userAgentBuilder.append(" ").append(this.userAgentSuffix);
            }
            return userAgentBuilder.toString();
        }
    }
}

