/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.event.progress.Allocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

public class ProgressDisplayGenerator {
    private static final String HEADER = "Executing tasks:";
    private static final int PROGRESS_BAR_COUNT = 30;

    public static List<String> generateProgressDisplay(double progress, List<Allocation> unfinishedAllocations) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(HEADER);
        lines.add(ProgressDisplayGenerator.generateProgressBar(progress));
        lines.addAll(ProgressDisplayGenerator.generateUnfinishedTasks(unfinishedAllocations));
        return lines;
    }

    private static String generateProgressBar(double progress) {
        StringBuilder progressBar = new StringBuilder();
        progressBar.append('[');
        int barsToDisplay = (int)Math.round(30.0 * progress);
        for (int barIndex = 0; barIndex < 30; ++barIndex) {
            progressBar.append(barIndex < barsToDisplay ? (char)'=' : ' ');
        }
        return progressBar.append(']').append(String.format(" %.1f", progress * 100.0)).append("% complete").toString();
    }

    private static List<String> generateUnfinishedTasks(List<Allocation> unfinishedAllocations) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Allocation unfinishedAllocation : ProgressDisplayGenerator.getLeafAllocations(unfinishedAllocations)) {
            lines.add("> " + unfinishedAllocation.getDescription());
        }
        return lines;
    }

    private static List<Allocation> getLeafAllocations(List<Allocation> unfinishedAllocations) {
        HashSet<Allocation> leafAllocationSet = new HashSet<Allocation>(unfinishedAllocations);
        for (Allocation allocation : unfinishedAllocations) {
            Optional<Allocation> parent = allocation.getParent();
            while (parent.isPresent()) {
                leafAllocationSet.remove(parent.get());
                parent = parent.get().getParent();
            }
        }
        ArrayList<Allocation> leafAllocations = new ArrayList<Allocation>();
        for (Allocation allocation : unfinishedAllocations) {
            if (!leafAllocationSet.contains(allocation)) continue;
            leafAllocations.add(allocation);
        }
        return leafAllocations;
    }

    private ProgressDisplayGenerator() {
    }
}

