/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common.logging;

import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.plugins.common.logging.ConsoleLogger;
import com.google.cloud.tools.jib.plugins.common.logging.SingleThreadedExecutor;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.function.Consumer;

class PlainConsoleLogger
implements ConsoleLogger {
    private final ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers;
    private final SingleThreadedExecutor singleThreadedExecutor;

    PlainConsoleLogger(ImmutableMap<LogEvent.Level, Consumer<String>> messageConsumers, SingleThreadedExecutor singleThreadedExecutor) {
        this.messageConsumers = messageConsumers;
        this.singleThreadedExecutor = singleThreadedExecutor;
    }

    @Override
    public void log(LogEvent.Level logLevel, String message) {
        if (!this.messageConsumers.containsKey((Object)logLevel)) {
            return;
        }
        Consumer messageConsumer = (Consumer)this.messageConsumers.get((Object)logLevel);
        this.singleThreadedExecutor.execute(() -> messageConsumer.accept(message));
    }

    @Override
    public void setFooter(List<String> footerLines) {
    }
}

