/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.plugins.common;

import com.google.cloud.tools.jib.configuration.credentials.Credential;
import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.HelpfulSuggestions;
import com.google.cloud.tools.jib.plugins.common.RawConfiguration;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ConfigurationPropertyValidator {
    private static final Pattern ENVIRONMENT_PATTERN = Pattern.compile("(?<name>[^=]+)=(?<value>.*)");

    public static Optional<Credential> getImageCredential(EventDispatcher eventDispatcher, String usernameProperty, String passwordProperty, AuthProperty auth, RawConfiguration rawConfiguration) {
        String commandlineUsername = rawConfiguration.getProperty(usernameProperty).orElse(null);
        String commandlinePassword = rawConfiguration.getProperty(passwordProperty).orElse(null);
        if (!Strings.isNullOrEmpty((String)commandlineUsername) && !Strings.isNullOrEmpty((String)commandlinePassword)) {
            return Optional.of(Credential.basic(commandlineUsername, commandlinePassword));
        }
        if (!Strings.isNullOrEmpty((String)commandlinePassword) && Strings.isNullOrEmpty((String)commandlineUsername)) {
            eventDispatcher.dispatch(LogEvent.warn(passwordProperty + " system property is set, but " + usernameProperty + " is not; attempting other authentication methods."));
        }
        if (!Strings.isNullOrEmpty((String)commandlineUsername) && Strings.isNullOrEmpty((String)commandlinePassword)) {
            eventDispatcher.dispatch(LogEvent.warn(usernameProperty + " system property is set, but " + passwordProperty + " is not; attempting other authentication methods."));
        }
        if (Strings.isNullOrEmpty((String)auth.getUsername()) && Strings.isNullOrEmpty((String)auth.getPassword())) {
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)auth.getUsername())) {
            eventDispatcher.dispatch(LogEvent.warn(auth.getUsernameDescriptor() + " is missing from build configuration; ignoring auth section."));
            return Optional.empty();
        }
        if (Strings.isNullOrEmpty((String)auth.getPassword())) {
            eventDispatcher.dispatch(LogEvent.warn(auth.getPasswordDescriptor() + " is missing from build configuration; ignoring auth section."));
            return Optional.empty();
        }
        return Optional.of(Credential.basic(auth.getUsername(), auth.getPassword()));
    }

    public static ImageReference getGeneratedTargetDockerTag(@Nullable String targetImage, EventDispatcher eventDispatcher, String generatedName, String generatedTag, HelpfulSuggestions helpfulSuggestions) throws InvalidImageReferenceException {
        if (Strings.isNullOrEmpty((String)targetImage)) {
            eventDispatcher.dispatch(LogEvent.lifecycle(helpfulSuggestions.forGeneratedTag(generatedName, generatedTag)));
            ImageReference.parse(generatedName + ":" + generatedTag);
            return ImageReference.of(null, generatedName, generatedTag);
        }
        return ImageReference.parse(targetImage);
    }

    public static Map<String, String> parseMapProperty(String property) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> entries = ConfigurationPropertyValidator.parseListProperty(property);
        for (String entry : entries) {
            Matcher matcher = ENVIRONMENT_PATTERN.matcher(entry);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("'" + entry + "' is not a valid key-value pair");
            }
            result.put(matcher.group("name"), matcher.group("value"));
        }
        return ImmutableMap.copyOf(result);
    }

    public static List<String> parseListProperty(String property) {
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        for (int endIndex = 0; endIndex < property.length(); ++endIndex) {
            if (property.charAt(endIndex) == ',') {
                items.add(property.substring(startIndex, endIndex));
                startIndex = endIndex + 1;
                continue;
            }
            if (property.charAt(endIndex) != '\\') continue;
            ++endIndex;
        }
        items.add(property.substring(startIndex));
        return ImmutableList.copyOf(items);
    }

    private ConfigurationPropertyValidator() {
    }
}

