/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import javax.annotation.Nullable;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;

class ProxyProvider {
    private static final ImmutableList<String> PROXY_PROPERTIES = ImmutableList.of((Object)"proxyHost", (Object)"proxyPort", (Object)"proxyUser", (Object)"proxyPassword");

    ProxyProvider() {
    }

    static void init(Settings settings) {
        ProxyProvider.configureProxy(settings, "https");
        ProxyProvider.configureProxy(settings, "http");
    }

    private static void configureProxy(Settings settings, String protocol) {
        settings.getProxies().stream().filter(Proxy::isActive).filter(proxy -> protocol.equals(proxy.getProtocol())).findFirst().ifPresent(ProxyProvider::setProxyProperties);
    }

    @VisibleForTesting
    static void setProxyProperties(Proxy proxy) {
        String protocol = proxy.getProtocol();
        if (ProxyProvider.areProxyPropertiesSet(protocol)) {
            return;
        }
        ProxyProvider.setPropertySafe(protocol + ".proxyHost", proxy.getHost());
        ProxyProvider.setPropertySafe(protocol + ".proxyPort", String.valueOf(proxy.getPort()));
        ProxyProvider.setPropertySafe(protocol + ".proxyUser", proxy.getUsername());
        ProxyProvider.setPropertySafe(protocol + ".proxyPassword", proxy.getPassword());
        ProxyProvider.setPropertySafe("http.nonProxyHosts", proxy.getNonProxyHosts());
    }

    private static void setPropertySafe(String property, @Nullable String value) {
        if (value != null) {
            System.setProperty(property, value);
        }
    }

    @VisibleForTesting
    static boolean areProxyPropertiesSet(String protocol) {
        return PROXY_PROPERTIES.stream().anyMatch(property -> System.getProperty(protocol + "." + property) != null);
    }
}

