/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.InferredAuthProvider;
import com.google.cloud.tools.jib.plugins.common.InferredAuthRetrievalException;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

class MavenSettingsServerCredentials
implements InferredAuthProvider {
    static final String CREDENTIAL_SOURCE = "Maven settings";
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final Settings settings;
    @Nullable
    private final SettingsDecrypter settingsDecrypter;
    private final EventDispatcher eventDispatcher;

    @VisibleForTesting
    static boolean isEncrypted(String password) {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(password);
        return matcher.matches() || matcher.find();
    }

    MavenSettingsServerCredentials(Settings settings, @Nullable SettingsDecrypter settingsDecrypter, EventDispatcher eventDispatcher) {
        this.settings = settings;
        this.settingsDecrypter = settingsDecrypter;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public Optional<AuthProperty> getAuth(String registry) throws InferredAuthRetrievalException {
        Server registryServer = this.settings.getServer(registry);
        if (registryServer == null) {
            return Optional.empty();
        }
        if (this.settingsDecrypter != null) {
            DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(registryServer);
            SettingsDecryptionResult result = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)request);
            for (SettingsProblem problem : result.getProblems()) {
                if (problem.getSeverity() != SettingsProblem.Severity.ERROR && problem.getSeverity() != SettingsProblem.Severity.FATAL) continue;
                throw new InferredAuthRetrievalException("Unable to decrypt password for " + registry + ": " + problem);
            }
            if (result.getServer() != null) {
                registryServer = result.getServer();
            }
        } else if (MavenSettingsServerCredentials.isEncrypted(registryServer.getPassword())) {
            this.eventDispatcher.dispatch(LogEvent.warn("Server password for registry " + registry + " appears to be encrypted, but there is no decrypter available"));
        }
        final String username = registryServer.getUsername();
        final String password = registryServer.getPassword();
        return Optional.of(new AuthProperty(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public String getPassword() {
                return password;
            }

            @Override
            public String getAuthDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getUsernameDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }

            @Override
            public String getPasswordDescriptor() {
                return MavenSettingsServerCredentials.CREDENTIAL_SOURCE;
            }
        });
    }
}

