/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.cloud.tools.jib.plugins.common.ConfigurationPropertyValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;

public abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Parameter
    private ExtraDirectoryParameters extraDirectory = new ExtraDirectoryParameters();
    @Parameter(defaultValue="false", required=true, property="jib.allowInsecureRegistries")
    private boolean allowInsecureRegistries;
    @Parameter(defaultValue="false", property="jib.skip")
    private boolean skip;
    @Nullable
    @Component
    protected SettingsDecrypter settingsDecrypter;

    MavenSession getSession() {
        return (MavenSession)Preconditions.checkNotNull((Object)this.session);
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    @Nullable
    String getBaseImage() {
        String property = this.getProperty("jib.from.image");
        if (property != null) {
            return property;
        }
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image;
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        String property = this.getProperty("jib.from.credHelper");
        if (property != null) {
            return property;
        }
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    AuthConfiguration getBaseImageAuth() {
        return this.from.auth;
    }

    @Nullable
    String getTargetImage() {
        String propertyAlternate = this.getProperty("image");
        if (propertyAlternate != null) {
            return propertyAlternate;
        }
        String property = this.getProperty("jib.to.image");
        if (property != null) {
            return property;
        }
        return this.to.image;
    }

    Set<String> getTargetImageAdditionalTags() {
        String property = this.getProperty("jib.to.tags");
        if (property != null) {
            return new HashSet<String>(ConfigurationPropertyValidator.parseListProperty(property));
        }
        return new HashSet<String>(this.to.tags);
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        String property = this.getProperty("jib.to.credHelper");
        if (property != null) {
            return property;
        }
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    AuthConfiguration getTargetImageAuth() {
        return this.to.auth;
    }

    boolean getUseCurrentTimestamp() {
        String property = this.getProperty("jib.container.useCurrentTimestamp");
        if (property != null) {
            return Boolean.parseBoolean(property);
        }
        return this.container.useCurrentTimestamp;
    }

    @Nullable
    List<String> getEntrypoint() {
        String property = this.getProperty("jib.container.entrypoint");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.entrypoint;
    }

    List<String> getJvmFlags() {
        String property = this.getProperty("jib.container.jvmFlags");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.jvmFlags;
    }

    Map<String, String> getEnvironment() {
        String property = this.getProperty("jib.container.environment");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.container.environment;
    }

    @Nullable
    String getMainClass() {
        String property = this.getProperty("jib.container.mainClass");
        if (property != null) {
            return property;
        }
        return this.container.mainClass;
    }

    @Nullable
    String getUser() {
        String property = this.getProperty("jib.container.user");
        if (property != null) {
            return property;
        }
        return this.container.user;
    }

    @Nullable
    String getWorkingDirectory() {
        String property = this.getProperty("jib.container.workingDirectory");
        if (property != null) {
            return property;
        }
        return this.container.workingDirectory;
    }

    @Nullable
    List<String> getArgs() {
        String property = this.getProperty("jib.container.args");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.args;
    }

    List<String> getExposedPorts() {
        String property = this.getProperty("jib.container.ports");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.ports;
    }

    List<String> getVolumes() {
        String property = this.getProperty("jib.container.volumes");
        if (property != null) {
            return ConfigurationPropertyValidator.parseListProperty(property);
        }
        return this.container.volumes;
    }

    Map<String, String> getLabels() {
        String property = this.getProperty("jib.container.labels");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property);
        }
        return this.container.labels;
    }

    String getAppRoot() {
        String property = this.getProperty("jib.container.appRoot");
        if (property != null) {
            return property;
        }
        return this.container.appRoot;
    }

    String getFormat() {
        String property = this.getProperty("jib.container.format");
        if (property != null) {
            return property;
        }
        return (String)Preconditions.checkNotNull((Object)this.container.format);
    }

    Optional<Path> getExtraDirectoryPath() {
        String property = this.getProperty("jib.extraDirectory.path");
        if (property != null) {
            return Optional.of(Paths.get(property, new String[0]));
        }
        return this.extraDirectory.path == null ? Optional.empty() : Optional.of(this.extraDirectory.path.toPath());
    }

    List<PermissionConfiguration> getExtraDirectoryPermissions() {
        String property = this.getProperty("jib.extraDirectory.permissions");
        if (property != null) {
            return ConfigurationPropertyValidator.parseMapProperty(property).entrySet().stream().map(entry -> new PermissionConfiguration((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }
        return this.extraDirectory.permissions;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    boolean isSkipped() {
        return this.skip;
    }

    SettingsDecrypter getSettingsDecrypter() {
        return (SettingsDecrypter)Preconditions.checkNotNull((Object)this.settingsDecrypter);
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @Nullable
    public String getProperty(String propertyName) {
        if (this.session != null && this.session.getSystemProperties().containsKey(propertyName)) {
            return this.session.getSystemProperties().getProperty(propertyName);
        }
        if (this.project != null && this.project.getProperties().containsKey(propertyName)) {
            return this.project.getProperties().getProperty(propertyName);
        }
        return null;
    }

    public static class ExtraDirectoryParameters {
        @Nullable
        @Parameter
        private File path;
        @Parameter
        private List<PermissionConfiguration> permissions = Collections.emptyList();

        public void set(File path) {
            this.path = path;
        }

        @Nullable
        public File getPath() {
            return this.path;
        }
    }

    public static class ContainerParameters {
        @Parameter
        private boolean useCurrentTimestamp = false;
        @Nullable
        @Parameter
        private List<String> entrypoint;
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Parameter
        private Map<String, String> environment = Collections.emptyMap();
        @Nullable
        @Parameter
        private String mainClass;
        @Nullable
        @Parameter
        private List<String> args;
        @Nullable
        @Parameter(required=true)
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
        @Parameter
        private List<String> volumes = Collections.emptyList();
        @Parameter
        private Map<String, String> labels = Collections.emptyMap();
        @Parameter
        private String appRoot = "";
        @Nullable
        @Parameter
        private String user;
        @Nullable
        @Parameter
        private String workingDirectory;
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Parameter
        private List<String> tags = Collections.emptyList();
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private ToAuthConfiguration auth = new ToAuthConfiguration();

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image;
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private FromAuthConfiguration auth = new FromAuthConfiguration();
    }

    public static class PermissionConfiguration {
        @Nullable
        @Parameter
        private String file;
        @Nullable
        @Parameter
        private String mode;

        public PermissionConfiguration() {
        }

        @VisibleForTesting
        PermissionConfiguration(String file, String mode) {
            this.file = file;
            this.mode = mode;
        }

        Optional<String> getFile() {
            return Optional.ofNullable(this.file);
        }

        Optional<String> getMode() {
            return Optional.ofNullable(this.mode);
        }
    }

    public static class ToAuthConfiguration
    extends AuthConfiguration {
        public ToAuthConfiguration() {
            super("to");
        }
    }

    public static class FromAuthConfiguration
    extends AuthConfiguration {
        public FromAuthConfiguration() {
            super("from");
        }
    }

    private static class AuthConfiguration
    implements AuthProperty {
        @Nullable
        @Parameter
        private String username;
        @Nullable
        @Parameter
        private String password;
        private final String source;

        private AuthConfiguration(String source) {
            this.source = source;
        }

        @Override
        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Override
        @Nullable
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getAuthDescriptor() {
            return "<" + this.source + "><auth>";
        }

        @Override
        public String getUsernameDescriptor() {
            return this.getAuthDescriptor() + "<username>";
        }

        @Override
        public String getPasswordDescriptor() {
            return this.getAuthDescriptor() + "<password>";
        }
    }
}

