/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MainClassFinder {
    private final ImmutableList<Path> files;
    private final EventDispatcher eventDispatcher;

    public MainClassFinder(ImmutableList<Path> files, EventDispatcher eventDispatcher) {
        this.files = files;
        this.eventDispatcher = eventDispatcher;
    }

    public Result find() {
        ArrayList mainClasses = new ArrayList();
        for (Path file : this.files) {
            this.findMainClass(file).ifPresent(mainClasses::add);
        }
        if (mainClasses.size() == 1) {
            return Result.success((String)mainClasses.get(0));
        }
        if (mainClasses.size() == 0) {
            return Result.mainClassNotFound();
        }
        return Result.multipleMainClasses(mainClasses);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> findMainClass(Path file) {
        if (!Files.exists(file, new LinkOption[0])) return Optional.empty();
        if (!Files.isRegularFile(file, new LinkOption[0])) return Optional.empty();
        if (!file.toString().endsWith(".class")) {
            return Optional.empty();
        }
        MainClassVisitor mainClassVisitor = new MainClassVisitor();
        try (InputStream classFileInputStream = Files.newInputStream(file, new OpenOption[0]);){
            ClassReader reader = new ClassReader(classFileInputStream);
            reader.accept((ClassVisitor)mainClassVisitor, 0);
            if (!mainClassVisitor.visitedMainClass) return Optional.empty();
            Optional<String> optional = Optional.of(reader.getClassName().replace('/', '.'));
            return optional;
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            this.eventDispatcher.dispatch(LogEvent.warn("Invalid class file found: " + file));
            return Optional.empty();
        }
        catch (IOException ignored) {
            this.eventDispatcher.dispatch(LogEvent.warn("Could not read file: " + file));
        }
        return Optional.empty();
    }

    private static class MainClassVisitor
    extends ClassVisitor {
        private static final String MAIN_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String[].class)});
        private static final int OPTIONAL_ACCESS = 131088;
        private boolean visitedMainClass;

        private MainClassVisitor() {
            super(458752);
        }

        @Nullable
        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if ((access & 0xFFFDFFEF) == 9 && name.equals("main") && descriptor.equals(MAIN_DESCRIPTOR)) {
                this.visitedMainClass = true;
            }
            return null;
        }
    }

    public static class Result {
        private final Type type;
        private final List<String> foundMainClasses;

        private static Result success(String foundMainClass) {
            return new Result(Type.MAIN_CLASS_FOUND, Collections.singletonList(foundMainClass));
        }

        private static Result mainClassNotFound() {
            return new Result(Type.MAIN_CLASS_NOT_FOUND, Collections.emptyList());
        }

        private static Result multipleMainClasses(List<String> foundMainClasses) {
            return new Result(Type.MULTIPLE_MAIN_CLASSES, foundMainClasses);
        }

        private Result(Type type, List<String> foundMainClasses) {
            this.foundMainClasses = foundMainClasses;
            this.type = type;
        }

        public String getFoundMainClass() {
            Preconditions.checkState((Type.MAIN_CLASS_FOUND == this.type ? 1 : 0) != 0);
            Preconditions.checkState((this.foundMainClasses.size() == 1 ? 1 : 0) != 0);
            return this.foundMainClasses.get(0);
        }

        public Type getType() {
            return (Type)((Object)Preconditions.checkNotNull((Object)((Object)this.type)));
        }

        public List<String> getFoundMainClasses() {
            return this.foundMainClasses;
        }

        public static enum Type {
            MAIN_CLASS_FOUND,
            MAIN_CLASS_NOT_FOUND,
            MULTIPLE_MAIN_CLASSES;

        }
    }
}

