/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TemporaryDirectory
implements Closeable {
    private final Path temporaryDirectory;

    public TemporaryDirectory(Path parentDirectory) throws IOException {
        this.temporaryDirectory = Files.createTempDirectory(parentDirectory, null, new FileAttribute[0]);
    }

    public Path getDirectory() {
        return this.temporaryDirectory;
    }

    @Override
    public void close() throws IOException {
        if (Files.exists(this.temporaryDirectory, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
    }
}

