/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.event.progress;

import java.util.Optional;
import javax.annotation.Nullable;

public class Allocation {
    @Nullable
    private final Allocation parent;
    private final String description;
    private final long allocationUnits;
    private final double fractionOfRoot;

    public static Allocation newRoot(String description, long allocationUnits) {
        return new Allocation(description, allocationUnits, null);
    }

    private Allocation(String description, long allocationUnits, @Nullable Allocation parent) {
        this.description = description;
        this.allocationUnits = allocationUnits;
        this.parent = parent;
        this.fractionOfRoot = (parent == null ? 1.0 : parent.fractionOfRoot) / (double)allocationUnits;
    }

    public Allocation newChild(String description, long allocationUnits) {
        return new Allocation(description, allocationUnits, this);
    }

    public Optional<Allocation> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public String getDescription() {
        return this.description;
    }

    public long getAllocationUnits() {
        return this.allocationUnits;
    }

    public double getFractionOfRoot() {
        return this.fractionOfRoot;
    }
}

