/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.docker.json.DockerLoadManifestEntryTemplate;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import java.io.IOException;
import java.util.Collections;

public class ImageToTarballTranslator {
    private static final String CONTAINER_CONFIGURATION_JSON_FILE_NAME = "config.json";
    private static final String MANIFEST_JSON_FILE_NAME = "manifest.json";
    private static final String LAYER_FILE_EXTENSION = ".tar.gz";
    private final Image<Layer> image;

    public ImageToTarballTranslator(Image<Layer> image) {
        this.image = image;
    }

    public Blob toTarballBlob(ImageReference imageReference) throws IOException {
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        DockerLoadManifestEntryTemplate manifestTemplate = new DockerLoadManifestEntryTemplate();
        for (Layer layer : this.image.getLayers()) {
            String layerName = layer.getBlobDescriptor().getDigest().getHash() + LAYER_FILE_EXTENSION;
            tarStreamBuilder.addBlobEntry(layer.getBlob(), layer.getBlobDescriptor().getSize(), layerName);
            manifestTemplate.addLayerFile(layerName);
        }
        Blob containerConfigurationBlob = new ImageToJsonTranslator(this.image).getContainerConfigurationBlob();
        tarStreamBuilder.addByteEntry(Blobs.writeToByteArray(containerConfigurationBlob), CONTAINER_CONFIGURATION_JSON_FILE_NAME);
        manifestTemplate.setRepoTags(imageReference.toStringWithTag());
        tarStreamBuilder.addByteEntry(Blobs.writeToByteArray(JsonTemplateMapper.toBlob(Collections.singletonList(manifestTemplate))), MANIFEST_JSON_FILE_NAME);
        return tarStreamBuilder.toBlob();
    }
}

