/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.configuration;

import com.google.cloud.tools.jib.configuration.credentials.CredentialRetriever;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ImageConfiguration {
    private final ImageReference image;
    private final ImmutableList<CredentialRetriever> credentialRetrievers;

    public static Builder builder(ImageReference imageReference) {
        return new Builder(imageReference);
    }

    private ImageConfiguration(ImageReference image, ImmutableList<CredentialRetriever> credentialRetrievers) {
        this.image = image;
        this.credentialRetrievers = credentialRetrievers;
    }

    public ImageReference getImage() {
        return this.image;
    }

    public String getImageRegistry() {
        return this.image.getRegistry();
    }

    public String getImageRepository() {
        return this.image.getRepository();
    }

    public String getImageTag() {
        return this.image.getTag();
    }

    public ImmutableList<CredentialRetriever> getCredentialRetrievers() {
        return this.credentialRetrievers;
    }

    public static class Builder {
        private ImageReference imageReference;
        private ImmutableList<CredentialRetriever> credentialRetrievers = ImmutableList.of();

        public Builder setCredentialRetrievers(List<CredentialRetriever> credentialRetrievers) {
            Preconditions.checkArgument((!credentialRetrievers.contains(null) ? 1 : 0) != 0, (Object)"credential retriever list contains null elements");
            this.credentialRetrievers = ImmutableList.copyOf(credentialRetrievers);
            return this;
        }

        public ImageConfiguration build() {
            return new ImageConfiguration(this.imageReference, this.credentialRetrievers);
        }

        private Builder(ImageReference imageReference) {
            this.imageReference = imageReference;
        }
    }
}

