/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorage;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.DefaultCacheStorageFiles;
import com.google.cloud.tools.jib.cache.DefaultCacheStorageReader;
import com.google.cloud.tools.jib.cache.DefaultCacheStorageWriter;
import com.google.cloud.tools.jib.cache.UncompressedCacheWrite;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;

class DefaultCacheStorage
implements CacheStorage {
    private final DefaultCacheStorageWriter defaultCacheStorageWriter;
    private final DefaultCacheStorageReader defaultCacheStorageReader;

    static CacheStorage withDirectory(Path cacheDirectory) {
        return new DefaultCacheStorage(new DefaultCacheStorageFiles(cacheDirectory));
    }

    private DefaultCacheStorage(DefaultCacheStorageFiles defaultCacheStorageFiles) {
        this.defaultCacheStorageWriter = new DefaultCacheStorageWriter(defaultCacheStorageFiles);
        this.defaultCacheStorageReader = new DefaultCacheStorageReader(defaultCacheStorageFiles);
    }

    @Override
    public CachedLayer write(UncompressedCacheWrite uncompressedCacheWrite) throws IOException {
        return this.defaultCacheStorageWriter.write(uncompressedCacheWrite);
    }

    @Override
    public CachedLayer write(Blob compressedLayerBlob) throws IOException {
        return this.defaultCacheStorageWriter.write(compressedLayerBlob);
    }

    @Override
    public Set<DescriptorDigest> fetchDigests() throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.fetchDigests();
    }

    @Override
    public Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.retrieve(layerDigest);
    }

    @Override
    public Optional<DescriptorDigest> select(DescriptorDigest selector) throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.select(selector);
    }
}

