/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.cache.CacheCorruptedException;
import com.google.cloud.tools.jib.cache.CacheStorage;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.DefaultCacheStorage;
import com.google.cloud.tools.jib.cache.LayerEntriesSelector;
import com.google.cloud.tools.jib.cache.UncompressedCacheWrite;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class Cache {
    private final CacheStorage cacheStorage;

    public static Cache withDirectory(Path cacheDirectory) throws IOException {
        Files.createDirectories(cacheDirectory, new FileAttribute[0]);
        return new Cache(DefaultCacheStorage.withDirectory(cacheDirectory));
    }

    private Cache(CacheStorage cacheStorage) {
        this.cacheStorage = cacheStorage;
    }

    public CachedLayer writeCompressedLayer(Blob compressedLayerBlob) throws IOException {
        return this.cacheStorage.write(compressedLayerBlob);
    }

    public CachedLayer writeUncompressedLayer(Blob uncompressedLayerBlob, ImmutableList<LayerEntry> layerEntries) throws IOException {
        return this.cacheStorage.write(new UncompressedCacheWrite(uncompressedLayerBlob, LayerEntriesSelector.generateSelector(layerEntries)));
    }

    public Optional<CachedLayer> retrieve(ImmutableList<LayerEntry> layerEntries) throws IOException, CacheCorruptedException {
        Optional<DescriptorDigest> optionalSelectedLayerDigest = this.cacheStorage.select(LayerEntriesSelector.generateSelector(layerEntries));
        if (!optionalSelectedLayerDigest.isPresent()) {
            return Optional.empty();
        }
        return this.cacheStorage.retrieve(optionalSelectedLayerDigest.get());
    }

    public Optional<CachedLayer> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.cacheStorage.retrieve(layerDigest);
    }
}

