/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.AsyncSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.LoadDockerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.builder.steps.PushContainerConfigurationStep;
import com.google.cloud.tools.jib.builder.steps.PushImageStep;
import com.google.cloud.tools.jib.builder.steps.PushLayersStep;
import com.google.cloud.tools.jib.builder.steps.RetrieveRegistryCredentialsStep;
import com.google.cloud.tools.jib.builder.steps.WriteTarFileStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.global.JibSystemProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;

public class StepsRunner {
    private final Steps steps = new Steps();
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    private Runnable stepsRunnable = () -> {};
    private int stepsCount = 0;
    @Nullable
    private String rootProgressAllocationDescription;
    @Nullable
    private ProgressEventDispatcher rootProgressEventDispatcher;

    public static StepsRunner begin(BuildConfiguration buildConfiguration) {
        Object executorService = JibSystemProperties.isSerializedExecutionEnabled() ? MoreExecutors.newDirectExecutorService() : buildConfiguration.getExecutorService();
        return new StepsRunner(MoreExecutors.listeningDecorator((ExecutorService)executorService), buildConfiguration);
    }

    private StepsRunner(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
    }

    public StepsRunner retrieveTargetRegistryCredentials() {
        return this.enqueueStep(() -> this.steps.retrieveTargetRegistryCredentialsStep = RetrieveRegistryCredentialsStep.forTargetImage(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer()));
    }

    public StepsRunner authenticatePush() {
        return this.enqueueStep(() -> this.steps.authenticatePushStep = new AuthenticatePushStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (RetrieveRegistryCredentialsStep)Preconditions.checkNotNull((Object)this.steps.retrieveTargetRegistryCredentialsStep)));
    }

    public StepsRunner pullBaseImage() {
        return this.enqueueStep(() -> this.steps.pullBaseImageStep = new PullBaseImageStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer()));
    }

    public StepsRunner pullAndCacheBaseImageLayers() {
        return this.enqueueStep(() -> this.steps.pullAndCacheBaseImageLayersStep = new PullAndCacheBaseImageLayersStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (PullBaseImageStep)Preconditions.checkNotNull((Object)this.steps.pullBaseImageStep)));
    }

    public StepsRunner pushBaseImageLayers() {
        return this.enqueueStep(() -> this.steps.pushBaseImageLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.steps.authenticatePushStep), (AsyncStep)Preconditions.checkNotNull((Object)this.steps.pullAndCacheBaseImageLayersStep)));
    }

    public StepsRunner buildAndCacheApplicationLayers() {
        return this.enqueueStep(() -> this.steps.buildAndCacheApplicationLayerSteps = BuildAndCacheApplicationLayerStep.makeList(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer()));
    }

    public StepsRunner buildImage() {
        return this.enqueueStep(() -> this.steps.buildImageStep = new BuildImageStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (PullBaseImageStep)Preconditions.checkNotNull((Object)this.steps.pullBaseImageStep), (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.steps.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull((Object)this.steps.buildAndCacheApplicationLayerSteps))));
    }

    public StepsRunner pushContainerConfiguration() {
        return this.enqueueStep(() -> this.steps.pushContainerConfigurationStep = new PushContainerConfigurationStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.steps.authenticatePushStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.steps.buildImageStep)));
    }

    public StepsRunner pushApplicationLayers() {
        return this.enqueueStep(() -> this.steps.pushApplicationLayersStep = new PushLayersStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.steps.authenticatePushStep), AsyncSteps.immediate((ImmutableList)Preconditions.checkNotNull((Object)this.steps.buildAndCacheApplicationLayerSteps))));
    }

    public StepsRunner pushImage() {
        this.rootProgressAllocationDescription = "building image to registry";
        return this.enqueueStep(() -> this.steps.finalStep = new PushImageStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), (AuthenticatePushStep)Preconditions.checkNotNull((Object)this.steps.authenticatePushStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.steps.pushBaseImageLayersStep), (PushLayersStep)Preconditions.checkNotNull((Object)this.steps.pushApplicationLayersStep), (PushContainerConfigurationStep)Preconditions.checkNotNull((Object)this.steps.pushContainerConfigurationStep), (BuildImageStep)Preconditions.checkNotNull((Object)this.steps.buildImageStep)));
    }

    public StepsRunner loadDocker(DockerClient dockerClient) {
        this.rootProgressAllocationDescription = "building image to Docker daemon";
        return this.enqueueStep(() -> this.steps.finalStep = new LoadDockerStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), dockerClient, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.steps.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull((Object)this.steps.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.steps.buildImageStep)));
    }

    public StepsRunner writeTarFile(Path outputPath) {
        this.rootProgressAllocationDescription = "building image to tar file";
        return this.enqueueStep(() -> this.steps.finalStep = new WriteTarFileStep(this.listeningExecutorService, this.buildConfiguration, ((ProgressEventDispatcher)Preconditions.checkNotNull((Object)this.rootProgressEventDispatcher)).newChildProducer(), outputPath, (PullAndCacheBaseImageLayersStep)Preconditions.checkNotNull((Object)this.steps.pullAndCacheBaseImageLayersStep), (ImmutableList<BuildAndCacheApplicationLayerStep>)((ImmutableList)Preconditions.checkNotNull((Object)this.steps.buildAndCacheApplicationLayerSteps)), (BuildImageStep)Preconditions.checkNotNull((Object)this.steps.buildImageStep)));
    }

    public BuildResult run() throws ExecutionException, InterruptedException {
        Preconditions.checkNotNull((Object)this.rootProgressAllocationDescription);
        try (ProgressEventDispatcher progressEventDispatcher = ProgressEventDispatcher.newRoot(this.buildConfiguration.getEventDispatcher(), this.rootProgressAllocationDescription, this.stepsCount);){
            this.rootProgressEventDispatcher = progressEventDispatcher;
            this.stepsRunnable.run();
            BuildResult buildResult = (BuildResult)((AsyncStep)Preconditions.checkNotNull((Object)this.steps.finalStep)).getFuture().get();
            return buildResult;
        }
    }

    private StepsRunner enqueueStep(Runnable stepRunnable) {
        Runnable previousStepsRunnable = this.stepsRunnable;
        this.stepsRunnable = () -> {
            previousStepsRunnable.run();
            stepRunnable.run();
        };
        ++this.stepsCount;
        return this;
    }

    private static class Steps {
        @Nullable
        private RetrieveRegistryCredentialsStep retrieveTargetRegistryCredentialsStep;
        @Nullable
        private AuthenticatePushStep authenticatePushStep;
        @Nullable
        private PullBaseImageStep pullBaseImageStep;
        @Nullable
        private PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
        @Nullable
        private ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
        @Nullable
        private PushLayersStep pushBaseImageLayersStep;
        @Nullable
        private PushLayersStep pushApplicationLayersStep;
        @Nullable
        private BuildImageStep buildImageStep;
        @Nullable
        private PushContainerConfigurationStep pushContainerConfigurationStep;
        @Nullable
        private AsyncStep<BuildResult> finalStep;

        private Steps() {
        }
    }
}

