/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.http.BlobProgressListener;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.time.Duration;
import javax.annotation.Nullable;

class ProgressEventDispatcherContainer
implements BlobProgressListener,
Closeable {
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final String description;
    @Nullable
    private ProgressEventDispatcher progressEventDispatcher;

    ProgressEventDispatcherContainer(ProgressEventDispatcher.Factory progressEventDispatcherFactory, String description) {
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.description = description;
    }

    @Override
    public void handleByteCount(long byteCount) {
        Preconditions.checkNotNull((Object)this.progressEventDispatcher);
        this.progressEventDispatcher.dispatchProgress(byteCount);
    }

    @Override
    public Duration getDelayBetweenCallbacks() {
        return Duration.ofMillis(100L);
    }

    @Override
    public void close() {
        Preconditions.checkNotNull((Object)this.progressEventDispatcher);
        this.progressEventDispatcher.close();
    }

    void initializeWithBlobSize(long blobSize) {
        Preconditions.checkState((this.progressEventDispatcher == null ? 1 : 0) != 0);
        this.progressEventDispatcher = this.progressEventDispatcherFactory.create(this.description, blobSize);
    }
}

