/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.BuildResult;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.docker.ImageToTarballTranslator;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.Layer;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

class LoadDockerStep
implements AsyncStep<BuildResult>,
Callable<BuildResult> {
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final DockerClient dockerClient;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final BuildImageStep buildImageStep;
    private final ListenableFuture<BuildResult> listenableFuture;

    LoadDockerStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, DockerClient dockerClient, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.dockerClient = dockerClient;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(pullAndCacheBaseImageLayersStep).addStep(buildImageStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<BuildResult> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public BuildResult call() throws ExecutionException, InterruptedException {
        return (BuildResult)AsyncDependencies.using(this.listeningExecutorService).addSteps((List)NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)).addSteps((List<? extends AsyncStep<?>>)this.buildAndCacheApplicationLayerSteps).addStep(NonBlockingSteps.get(this.buildImageStep)).whenAllSucceed(this::afterPushBaseImageLayerFuturesFuture).get();
    }

    private BuildResult afterPushBaseImageLayerFuturesFuture() throws ExecutionException, InterruptedException, IOException {
        this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.progress("Loading to Docker daemon..."));
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("loading to Docker daemon", 1L);){
            Image<Layer> image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
            ImageReference targetImageReference = this.buildConfiguration.getTargetImageConfiguration().getImage();
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.debug(this.dockerClient.load(new ImageToTarballTranslator(image).toTarballBlob(targetImageReference))));
            for (String tag : this.buildConfiguration.getAllTargetImageTags()) {
                if (tag.equals(targetImageReference.getTag())) continue;
                this.dockerClient.tag(targetImageReference, targetImageReference.withTag(tag));
            }
            Object object = BuildResult.fromImage(image, this.buildConfiguration.getTargetFormat());
            return object;
        }
    }
}

