/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.ProjectInfo;
import com.google.cloud.tools.jib.async.AsyncDependencies;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.ProgressEventDispatcher;
import com.google.cloud.tools.jib.builder.TimerEventDispatcher;
import com.google.cloud.tools.jib.builder.steps.BuildAndCacheApplicationLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayerStep;
import com.google.cloud.tools.jib.builder.steps.PullAndCacheBaseImageLayersStep;
import com.google.cloud.tools.jib.builder.steps.PullBaseImageStep;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ContainerConfiguration;
import com.google.cloud.tools.jib.configuration.Port;
import com.google.cloud.tools.jib.event.events.LogEvent;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.HistoryEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

class BuildImageStep
implements AsyncStep<AsyncStep<Image<Layer>>>,
Callable<AsyncStep<Image<Layer>>> {
    private static final String DESCRIPTION = "Building container configuration";
    private final ListeningExecutorService listeningExecutorService;
    private final BuildConfiguration buildConfiguration;
    private final ProgressEventDispatcher.Factory progressEventDispatcherFactory;
    private final PullBaseImageStep pullBaseImageStep;
    private final PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep;
    private final ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps;
    private final ListenableFuture<AsyncStep<Image<Layer>>> listenableFuture;

    BuildImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, ProgressEventDispatcher.Factory progressEventDispatcherFactory, PullBaseImageStep pullBaseImageStep, PullAndCacheBaseImageLayersStep pullAndCacheBaseImageLayersStep, ImmutableList<BuildAndCacheApplicationLayerStep> buildAndCacheApplicationLayerSteps) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.progressEventDispatcherFactory = progressEventDispatcherFactory;
        this.pullBaseImageStep = pullBaseImageStep;
        this.pullAndCacheBaseImageLayersStep = pullAndCacheBaseImageLayersStep;
        this.buildAndCacheApplicationLayerSteps = buildAndCacheApplicationLayerSteps;
        this.listenableFuture = AsyncDependencies.using(listeningExecutorService).addStep(pullBaseImageStep).addStep(pullAndCacheBaseImageLayersStep).whenAllSucceed(this);
    }

    @Override
    public ListenableFuture<AsyncStep<Image<Layer>>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<Image<Layer>> call() throws ExecutionException {
        ListenableFuture<Image> future = AsyncDependencies.using(this.listeningExecutorService).addSteps((List)NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep)).addSteps((List<? extends AsyncStep<?>>)this.buildAndCacheApplicationLayerSteps).whenAllSucceed(this::afterCachedLayerSteps);
        return () -> future;
    }

    private Image<Layer> afterCachedLayerSteps() throws ExecutionException, LayerPropertyNotFoundException {
        Throwable throwable = null;
        try (ProgressEventDispatcher ignored = this.progressEventDispatcherFactory.create("building image format", 1L);){
            Object object;
            TimerEventDispatcher ignored2 = new TimerEventDispatcher(this.buildConfiguration.getEventDispatcher(), DESCRIPTION);
            Throwable throwable2 = null;
            try {
                Image.Builder<Layer> imageBuilder = Image.builder(this.buildConfiguration.getTargetFormat());
                Image<Layer> baseImage = NonBlockingSteps.get(this.pullBaseImageStep).getBaseImage();
                ContainerConfiguration containerConfiguration = this.buildConfiguration.getContainerConfiguration();
                List baseImageLayers = (List)NonBlockingSteps.get(this.pullAndCacheBaseImageLayersStep);
                for (PullAndCacheBaseImageLayerStep pullAndCacheBaseImageLayerStep : baseImageLayers) {
                    imageBuilder.addLayer(NonBlockingSteps.get(pullAndCacheBaseImageLayerStep));
                }
                int nonEmptyLayerCount = 0;
                for (HistoryEntry historyObject : baseImage.getHistory()) {
                    imageBuilder.addHistory(historyObject);
                    if (historyObject.hasCorrespondingLayer()) continue;
                    ++nonEmptyLayerCount;
                }
                imageBuilder.addEnvironment((Map<String, String>)baseImage.getEnvironment()).addLabels((Map<String, String>)baseImage.getLabels()).setHealthCheck(baseImage.getHealthCheck()).addExposedPorts((Set<Port>)baseImage.getExposedPorts()).addVolumes((Set<AbsoluteUnixPath>)baseImage.getVolumes()).setWorkingDirectory(baseImage.getWorkingDirectory());
                Instant layerCreationTime = containerConfiguration == null ? ContainerConfiguration.DEFAULT_CREATION_TIME : containerConfiguration.getCreationTime();
                for (int count = 0; count < baseImageLayers.size() - nonEmptyLayerCount; ++count) {
                    imageBuilder.addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setComment("auto-generated by Jib").build());
                }
                for (BuildAndCacheApplicationLayerStep buildAndCacheApplicationLayerStep : this.buildAndCacheApplicationLayerSteps) {
                    imageBuilder.addLayer(NonBlockingSteps.get(buildAndCacheApplicationLayerStep)).addHistory(HistoryEntry.builder().setCreationTimestamp(layerCreationTime).setAuthor("Jib").setCreatedBy(this.buildConfiguration.getToolName() + ":" + ProjectInfo.VERSION).setComment(buildAndCacheApplicationLayerStep.getLayerType()).build());
                }
                if (containerConfiguration != null) {
                    imageBuilder.addEnvironment((Map<String, String>)containerConfiguration.getEnvironmentMap()).setCreated(containerConfiguration.getCreationTime()).setUser(containerConfiguration.getUser()).setEntrypoint((List<String>)this.computeEntrypoint(baseImage, containerConfiguration)).setProgramArguments((List<String>)this.computeProgramArguments(baseImage, containerConfiguration)).addExposedPorts((Set<Port>)containerConfiguration.getExposedPorts()).addVolumes((Set<AbsoluteUnixPath>)containerConfiguration.getVolumes()).addLabels((Map<String, String>)containerConfiguration.getLabels());
                    if (containerConfiguration.getWorkingDirectory() != null) {
                        imageBuilder.setWorkingDirectory(containerConfiguration.getWorkingDirectory().toString());
                    }
                }
                object = imageBuilder.build();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        BuildImageStep.$closeResource(throwable2, ignored2);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            BuildImageStep.$closeResource(throwable2, ignored2);
            return object;
        }
    }

    @Nullable
    private ImmutableList<String> computeEntrypoint(Image<Layer> baseImage, ContainerConfiguration containerConfiguration) {
        ImmutableList<String> entrypointToUse;
        boolean shouldInherit = baseImage.getEntrypoint() != null && containerConfiguration.getEntrypoint() == null;
        ImmutableList<String> immutableList = entrypointToUse = shouldInherit ? baseImage.getEntrypoint() : containerConfiguration.getEntrypoint();
        if (entrypointToUse != null) {
            String logSuffix = shouldInherit ? " (inherited from base image)" : "";
            String message = "Container entrypoint set to " + entrypointToUse + logSuffix;
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle(""));
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle(message));
        }
        return entrypointToUse;
    }

    @Nullable
    private ImmutableList<String> computeProgramArguments(Image<Layer> baseImage, ContainerConfiguration containerConfiguration) {
        ImmutableList<String> programArgumentsToUse;
        boolean shouldInherit = baseImage.getProgramArguments() != null && containerConfiguration.getEntrypoint() == null && containerConfiguration.getProgramArguments() == null;
        ImmutableList<String> immutableList = programArgumentsToUse = shouldInherit ? baseImage.getProgramArguments() : containerConfiguration.getProgramArguments();
        if (programArgumentsToUse != null) {
            String logSuffix = shouldInherit ? " (inherited from base image)" : "";
            String message = "Container program arguments set to " + programArgumentsToUse + logSuffix;
            this.buildConfiguration.getEventDispatcher().dispatch(LogEvent.lifecycle(message));
        }
        return programArgumentsToUse;
    }
}

