/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.event.EventDispatcher;
import com.google.cloud.tools.jib.event.events.ProgressEvent;
import com.google.cloud.tools.jib.event.progress.Allocation;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.Closeable;

public class ProgressEventDispatcher
implements Closeable {
    private final EventDispatcher eventDispatcher;
    private final Allocation allocation;
    private long remainingAllocationUnits;
    private boolean closed = false;

    public static ProgressEventDispatcher newRoot(EventDispatcher eventDispatcher, String description, long allocationUnits) {
        return ProgressEventDispatcher.newProgressEventDispatcher(eventDispatcher, Allocation.newRoot(description, allocationUnits));
    }

    private static ProgressEventDispatcher newProgressEventDispatcher(EventDispatcher eventDispatcher, Allocation allocation) {
        ProgressEventDispatcher progressEventDispatcher = new ProgressEventDispatcher(eventDispatcher, allocation);
        progressEventDispatcher.dispatchProgress(0L);
        return progressEventDispatcher;
    }

    private ProgressEventDispatcher(EventDispatcher eventDispatcher, Allocation allocation) {
        this.eventDispatcher = eventDispatcher;
        this.allocation = allocation;
        this.remainingAllocationUnits = allocation.getAllocationUnits();
    }

    public Factory newChildProducer() {
        this.decrementRemainingAllocationUnits(1L);
        return new Factory(){
            private boolean used = false;

            @Override
            public ProgressEventDispatcher create(String description, long allocationUnits) {
                Preconditions.checkState((!this.used ? 1 : 0) != 0);
                this.used = true;
                return ProgressEventDispatcher.newProgressEventDispatcher(ProgressEventDispatcher.this.eventDispatcher, ProgressEventDispatcher.this.allocation.newChild(description, allocationUnits));
            }
        };
    }

    @Override
    public void close() {
        if (this.remainingAllocationUnits > 0L) {
            this.dispatchProgress(this.remainingAllocationUnits);
        }
        this.closed = true;
    }

    public void dispatchProgress(long progressUnits) {
        this.decrementRemainingAllocationUnits(progressUnits);
        this.eventDispatcher.dispatch(new ProgressEvent(this.allocation, progressUnits));
    }

    private void decrementRemainingAllocationUnits(long units) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.remainingAllocationUnits -= units;
        Verify.verify((this.remainingAllocationUnits >= 0L ? 1 : 0) != 0, (String)"Remaining allocation units less than 0 for '%s': %s", (Object)this.allocation.getDescription(), (long)this.remainingAllocationUnits);
    }

    @FunctionalInterface
    public static interface Factory {
        public ProgressEventDispatcher create(String var1, long var2);
    }
}

