/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.Jib;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.configuration.LayerConfiguration;
import com.google.cloud.tools.jib.filesystem.AbsoluteUnixPath;
import com.google.cloud.tools.jib.frontend.JavaEntrypointConstructor;
import com.google.cloud.tools.jib.frontend.JavaLayerConfigurations;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JavaContainerBuilder {
    private static final AbsoluteUnixPath APP_ROOT = AbsoluteUnixPath.get("/app");
    private static final AbsoluteUnixPath RESOURCES_PATH = APP_ROOT.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_RESOURCES_PATH_ON_IMAGE);
    private static final AbsoluteUnixPath CLASSES_PATH = APP_ROOT.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_CLASSES_PATH_ON_IMAGE);
    private static final AbsoluteUnixPath DEPENDENCIES_PATH = APP_ROOT.resolve(JavaEntrypointConstructor.DEFAULT_RELATIVE_DEPENDENCIES_PATH_ON_IMAGE);
    private static final AbsoluteUnixPath DEPENDENCIES_CLASSPATH = DEPENDENCIES_PATH.resolve("*");
    private static final AbsoluteUnixPath OTHERS_PATH = APP_ROOT.resolve("classpath");
    private final JibContainerBuilder jibContainerBuilder;
    private final JavaLayerConfigurations.Builder layerConfigurationsBuilder = JavaLayerConfigurations.builder();
    private final List<String> jvmFlags = new ArrayList<String>();
    private final LinkedHashSet<String> classpath = new LinkedHashSet(4);
    @Nullable
    private String mainClass;

    public static JavaContainerBuilder fromDistroless() throws InvalidImageReferenceException {
        return JavaContainerBuilder.from(RegistryImage.named("gcr.io/distroless/java"));
    }

    public static JavaContainerBuilder from(String baseImageReference) throws InvalidImageReferenceException {
        return JavaContainerBuilder.from(RegistryImage.named(baseImageReference));
    }

    public static JavaContainerBuilder from(ImageReference baseImageReference) {
        return JavaContainerBuilder.from(RegistryImage.named(baseImageReference));
    }

    public static JavaContainerBuilder from(RegistryImage registryImage) {
        return new JavaContainerBuilder(Jib.from(registryImage));
    }

    private JavaContainerBuilder(JibContainerBuilder jibContainerBuilder) {
        this.jibContainerBuilder = jibContainerBuilder;
    }

    public JavaContainerBuilder addDependencies(List<Path> dependencyFiles) throws IOException {
        for (Path file : dependencyFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        List duplicates = dependencyFiles.stream().map(Path::getFileName).map(Path::toString).collect(Collectors.groupingBy(filename -> filename, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Path file : dependencyFiles) {
            this.layerConfigurationsBuilder.addFile(file.getFileName().toString().contains("SNAPSHOT") ? JavaLayerConfigurations.LayerType.SNAPSHOT_DEPENDENCIES : JavaLayerConfigurations.LayerType.DEPENDENCIES, file, DEPENDENCIES_PATH.resolve(duplicates.contains(file.getFileName().toString()) ? file.getFileName().toString().replaceFirst("\\.jar$", "-" + Files.size(file)) + ".jar" : file.getFileName().toString()));
        }
        this.classpath.add(DEPENDENCIES_CLASSPATH.toString());
        return this;
    }

    public JavaContainerBuilder addDependencies(Path ... dependencyFiles) throws IOException {
        return this.addDependencies(Arrays.asList(dependencyFiles));
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory) throws IOException {
        return this.addResources(resourceFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addResources(Path resourceFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        return this.addDirectory(resourceFilesDirectory, RESOURCES_PATH, JavaLayerConfigurations.LayerType.RESOURCES, pathFilter);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory) throws IOException {
        return this.addClasses(classFilesDirectory, path -> true);
    }

    public JavaContainerBuilder addClasses(Path classFilesDirectory, Predicate<Path> pathFilter) throws IOException {
        return this.addDirectory(classFilesDirectory, CLASSES_PATH, JavaLayerConfigurations.LayerType.CLASSES, pathFilter);
    }

    public JavaContainerBuilder addToClasspath(List<Path> otherFiles) throws IOException {
        for (Path file : otherFiles) {
            if (Files.exists(file, new LinkOption[0])) continue;
            throw new NoSuchFileException(file.toString());
        }
        for (Path file : otherFiles) {
            if (Files.isDirectory(file, new LinkOption[0])) {
                this.layerConfigurationsBuilder.addDirectoryContents(JavaLayerConfigurations.LayerType.EXTRA_FILES, file, path -> true, OTHERS_PATH);
                continue;
            }
            this.layerConfigurationsBuilder.addFile(JavaLayerConfigurations.LayerType.EXTRA_FILES, file, OTHERS_PATH.resolve(file.getFileName()));
        }
        this.classpath.add(OTHERS_PATH.toString());
        return this;
    }

    public JavaContainerBuilder addToClasspath(Path ... otherFiles) throws IOException {
        return this.addToClasspath(Arrays.asList(otherFiles));
    }

    public JavaContainerBuilder addJvmFlag(String jvmFlag) {
        this.jvmFlags.add(jvmFlag);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(List<String> jvmFlags) {
        this.jvmFlags.addAll(jvmFlags);
        return this;
    }

    public JavaContainerBuilder addJvmFlags(String ... jvmFlags) {
        this.jvmFlags.addAll(Arrays.asList(jvmFlags));
        return this;
    }

    public JavaContainerBuilder setMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JibContainerBuilder toContainerBuilder() {
        if (this.mainClass == null) {
            throw new IllegalStateException("mainClass is null on JavaContainerBuilder; specify the main class using JavaContainerBuilder#setMainClass(String), or consider using a jib.frontend.MainClassFinder to infer the main class");
        }
        if (this.classpath.isEmpty()) {
            throw new IllegalStateException("Failed to construct entrypoint because no files were added to the JavaContainerBuilder");
        }
        this.jibContainerBuilder.setEntrypoint(JavaEntrypointConstructor.makeEntrypoint(new ArrayList<String>(this.classpath), this.jvmFlags, this.mainClass));
        this.jibContainerBuilder.setLayers((List<LayerConfiguration>)this.layerConfigurationsBuilder.build().getLayerConfigurations());
        return this.jibContainerBuilder;
    }

    private JavaContainerBuilder addDirectory(Path directory, AbsoluteUnixPath destination, JavaLayerConfigurations.LayerType layerType, Predicate<Path> pathFilter) throws IOException {
        if (!Files.exists(directory, new LinkOption[0])) {
            throw new NoSuchFileException(directory.toString());
        }
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            throw new NotDirectoryException(directory.toString());
        }
        this.layerConfigurationsBuilder.addDirectoryContents(layerType, directory, pathFilter, destination);
        this.classpath.add(destination.toString());
        return this;
    }
}

