/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.api;

import com.google.cloud.tools.jib.api.TargetImage;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.configuration.BuildConfiguration;
import com.google.cloud.tools.jib.configuration.ImageConfiguration;
import com.google.cloud.tools.jib.docker.DockerClient;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;

public class DockerDaemonImage
implements TargetImage {
    private final ImageReference imageReference;
    @Nullable
    private Path dockerExecutable;
    @Nullable
    private Map<String, String> dockerEnvironment;

    public static DockerDaemonImage named(ImageReference imageReference) {
        return new DockerDaemonImage(imageReference);
    }

    public static DockerDaemonImage named(String imageReference) throws InvalidImageReferenceException {
        return DockerDaemonImage.named(ImageReference.parse(imageReference));
    }

    private DockerDaemonImage(ImageReference imageReference) {
        this.imageReference = imageReference;
    }

    public DockerDaemonImage setDockerExecutable(Path dockerExecutable) {
        this.dockerExecutable = dockerExecutable;
        return this;
    }

    public DockerDaemonImage setDockerEnvironment(Map<String, String> dockerEnvironment) {
        this.dockerEnvironment = dockerEnvironment;
        return this;
    }

    @Override
    public ImageConfiguration toImageConfiguration() {
        return ImageConfiguration.builder(this.imageReference).build();
    }

    @Override
    public BuildSteps toBuildSteps(BuildConfiguration buildConfiguration) {
        DockerClient.Builder dockerClientBuilder = DockerClient.builder();
        if (this.dockerExecutable != null) {
            dockerClientBuilder.setDockerExecutable(this.dockerExecutable);
        }
        if (this.dockerEnvironment != null) {
            dockerClientBuilder.setDockerEnvironment((ImmutableMap<String, String>)ImmutableMap.copyOf(this.dockerEnvironment));
        }
        return BuildSteps.forBuildToDockerDaemon(dockerClientBuilder.build(), buildConfiguration);
    }
}

