/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.LayerEntry;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class LayerEntriesSelector {
    @VisibleForTesting
    static List<LayerEntryTemplate> toSortedJsonTemplates(List<LayerEntry> layerEntries) {
        ArrayList<LayerEntryTemplate> jsonTemplates = new ArrayList<LayerEntryTemplate>();
        for (LayerEntry entry : layerEntries) {
            jsonTemplates.add(new LayerEntryTemplate(entry));
        }
        Collections.sort(jsonTemplates);
        return jsonTemplates;
    }

    static DescriptorDigest generateSelector(ImmutableList<LayerEntry> layerEntries) throws IOException {
        return JsonTemplateMapper.toBlob(LayerEntriesSelector.toSortedJsonTemplates(layerEntries)).writeTo(ByteStreams.nullOutputStream()).getDigest();
    }

    private LayerEntriesSelector() {
    }

    @VisibleForTesting
    static class LayerEntryTemplate
    implements JsonTemplate,
    Comparable<LayerEntryTemplate> {
        private final String sourceFile;
        private final String extractionPath;

        @VisibleForTesting
        LayerEntryTemplate(LayerEntry layerEntry) {
            this.sourceFile = layerEntry.getAbsoluteSourceFileString();
            this.extractionPath = layerEntry.getAbsoluteExtractionPathString();
        }

        @Override
        public int compareTo(LayerEntryTemplate otherLayerEntryTemplate) {
            int sourceFileComparison = this.sourceFile.compareTo(otherLayerEntryTemplate.sourceFile);
            if (sourceFileComparison != 0) {
                return sourceFileComparison;
            }
            return this.extractionPath.compareTo(otherLayerEntryTemplate.extractionPath);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayerEntryTemplate)) {
                return false;
            }
            LayerEntryTemplate otherLayerEntryTemplate = (LayerEntryTemplate)other;
            return this.sourceFile.equals(otherLayerEntryTemplate.sourceFile) && this.extractionPath.equals(otherLayerEntryTemplate.extractionPath);
        }

        public int hashCode() {
            return Objects.hash(this.sourceFile, this.extractionPath);
        }
    }
}

