/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.ncache;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.ncache.CacheCorruptedException;
import com.google.cloud.tools.jib.ncache.CacheEntry;
import com.google.cloud.tools.jib.ncache.CacheStorage;
import com.google.cloud.tools.jib.ncache.CacheWrite;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorageFiles;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorageReader;
import com.google.cloud.tools.jib.ncache.DefaultCacheStorageWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;

class DefaultCacheStorage
implements CacheStorage {
    private final DefaultCacheStorageWriter defaultCacheStorageWriter;
    private final DefaultCacheStorageReader defaultCacheStorageReader;

    static CacheStorage withDirectory(Path cacheDirectory) {
        return new DefaultCacheStorage(new DefaultCacheStorageFiles(cacheDirectory));
    }

    private DefaultCacheStorage(DefaultCacheStorageFiles defaultCacheStorageFiles) {
        this.defaultCacheStorageWriter = new DefaultCacheStorageWriter(defaultCacheStorageFiles);
        this.defaultCacheStorageReader = new DefaultCacheStorageReader(defaultCacheStorageFiles);
    }

    @Override
    public CacheEntry write(CacheWrite cacheWrite) throws IOException {
        return this.defaultCacheStorageWriter.write(cacheWrite);
    }

    @Override
    public Set<DescriptorDigest> fetchDigests() throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.fetchDigests();
    }

    @Override
    public Optional<CacheEntry> retrieve(DescriptorDigest layerDigest) throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.retrieve(layerDigest);
    }

    @Override
    public Optional<DescriptorDigest> select(DescriptorDigest selector) throws IOException, CacheCorruptedException {
        return this.defaultCacheStorageReader.select(selector);
    }
}

