/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.maven;

import com.google.cloud.tools.jib.JibLogger;
import com.google.cloud.tools.jib.plugins.common.AuthProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.crypto.SettingsDecrypter;

abstract class JibPluginConfiguration
extends AbstractMojo {
    @Nullable
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Nullable
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter
    private FromConfiguration from = new FromConfiguration();
    @Parameter(property="image")
    private ToConfiguration to = new ToConfiguration();
    @Parameter
    private ContainerParameters container = new ContainerParameters();
    @Deprecated
    @Parameter
    private List<String> jvmFlags = Collections.emptyList();
    @Deprecated
    @Nullable
    @Parameter
    private String mainClass;
    @Deprecated
    @Parameter
    private List<String> args = Collections.emptyList();
    @Deprecated
    @Nullable
    @Parameter
    private String format;
    @Parameter(defaultValue="false", required=true)
    private boolean useOnlyProjectCache;
    @Parameter(defaultValue="false", required=true)
    private boolean allowInsecureRegistries;
    @Nullable
    @Parameter(defaultValue="${project.basedir}/src/main/jib", required=true)
    private File extraDirectory;
    @Parameter(defaultValue="false", property="jib.skip")
    private boolean skip;
    @Nullable
    @Component
    protected SettingsDecrypter settingsDecrypter;

    JibPluginConfiguration() {
        this.to.auth.setPropertyDescriptors("<to><auth>");
        this.from.auth.setPropertyDescriptors("<from><auth>");
    }

    void handleDeprecatedParameters(JibLogger logger) {
        StringBuilder deprecatedParams = new StringBuilder();
        if (!this.jvmFlags.isEmpty()) {
            deprecatedParams.append("  <jvmFlags> -> <container><jvmFlags>\n");
            if (this.container.jvmFlags.isEmpty()) {
                this.container.jvmFlags = this.jvmFlags;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.mainClass)) {
            deprecatedParams.append("  <mainClass> -> <container><mainClass>\n");
            if (Strings.isNullOrEmpty((String)this.container.mainClass)) {
                this.container.mainClass = this.mainClass;
            }
        }
        if (!this.args.isEmpty()) {
            deprecatedParams.append("  <args> -> <container><args>\n");
            if (this.container.args.isEmpty()) {
                this.container.args = this.args;
            }
        }
        if (!Strings.isNullOrEmpty((String)this.format)) {
            deprecatedParams.append("  <format> -> <container><format>\n");
            this.container.format = this.format;
        }
        if (deprecatedParams.length() > 0) {
            logger.warn("There are deprecated parameters used in the build configuration. Please make the following changes to your pom.xml to avoid issues in the future:\n" + deprecatedParams);
        }
    }

    MavenSession getSession() {
        return (MavenSession)Preconditions.checkNotNull((Object)this.session);
    }

    MavenProject getProject() {
        return (MavenProject)Preconditions.checkNotNull((Object)this.project);
    }

    String getBaseImage() {
        return (String)Preconditions.checkNotNull((Object)((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).image);
    }

    @Nullable
    String getBaseImageCredentialHelperName() {
        return ((FromConfiguration)Preconditions.checkNotNull((Object)this.from)).credHelper;
    }

    AuthConfiguration getBaseImageAuth() {
        return this.from.auth;
    }

    @Nullable
    String getTargetImage() {
        return this.to.image;
    }

    Set<String> getTargetImageAdditionalTags() {
        return new HashSet<String>(this.to.tags);
    }

    @Nullable
    String getTargetImageCredentialHelperName() {
        return ((ToConfiguration)Preconditions.checkNotNull((Object)this.to)).credHelper;
    }

    AuthConfiguration getTargetImageAuth() {
        return this.to.auth;
    }

    boolean getUseCurrentTimestamp() {
        return this.container.useCurrentTimestamp;
    }

    List<String> getEntrypoint() {
        return this.container.entrypoint;
    }

    List<String> getJvmFlags() {
        return this.container.jvmFlags;
    }

    @Nullable
    Map<String, String> getEnvironment() {
        return this.container.environment;
    }

    @Nullable
    String getMainClass() {
        return this.container.mainClass;
    }

    List<String> getArgs() {
        return this.container.args;
    }

    List<String> getExposedPorts() {
        return this.container.ports;
    }

    Map<String, String> getLabels() {
        return this.container.labels;
    }

    String getAppRoot() {
        return this.container.appRoot;
    }

    String getFormat() {
        return (String)Preconditions.checkNotNull((Object)this.container.format);
    }

    boolean getUseOnlyProjectCache() {
        return this.useOnlyProjectCache;
    }

    boolean getAllowInsecureRegistries() {
        return this.allowInsecureRegistries;
    }

    Path getExtraDirectory() {
        return ((File)Preconditions.checkNotNull((Object)this.extraDirectory)).toPath();
    }

    boolean isSkipped() {
        return this.skip;
    }

    SettingsDecrypter getSettingsDecrypter() {
        return (SettingsDecrypter)Preconditions.checkNotNull((Object)this.settingsDecrypter);
    }

    @VisibleForTesting
    void setJvmFlags(List<String> jvmFlags) {
        this.jvmFlags = jvmFlags;
    }

    @VisibleForTesting
    void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @VisibleForTesting
    void setArgs(List<String> args) {
        this.args = args;
    }

    @VisibleForTesting
    void setFormat(String format) {
        this.format = format;
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @VisibleForTesting
    void setExtraDirectory(File extraDirectory) {
        this.extraDirectory = extraDirectory;
    }

    public static class ContainerParameters {
        @Parameter
        private boolean useCurrentTimestamp = false;
        @Parameter
        private List<String> entrypoint = Collections.emptyList();
        @Parameter
        private List<String> jvmFlags = Collections.emptyList();
        @Parameter
        private Map<String, String> environment = Collections.emptyMap();
        @Nullable
        @Parameter
        private String mainClass;
        @Parameter
        private List<String> args = Collections.emptyList();
        @Nullable
        @Parameter(required=true)
        private String format = "Docker";
        @Parameter
        private List<String> ports = Collections.emptyList();
        @Parameter
        private Map<String, String> labels = Collections.emptyMap();
        @Parameter
        private String appRoot = "/app";
    }

    public static class ToConfiguration {
        @Nullable
        @Parameter
        private String image;
        @Parameter
        private List<String> tags = Collections.emptyList();
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private AuthConfiguration auth = new AuthConfiguration();

        public void set(String image) {
            this.image = image;
        }
    }

    public static class FromConfiguration {
        @Nullable
        @Parameter(required=true)
        private String image = "gcr.io/distroless/java";
        @Nullable
        @Parameter
        private String credHelper;
        @Parameter
        private AuthConfiguration auth = new AuthConfiguration();
    }

    public static class AuthConfiguration
    implements AuthProperty {
        @Nullable
        @Parameter
        private String username;
        @Nullable
        @Parameter
        private String password;
        @Nullable
        private String usernameDescriptor;
        @Nullable
        private String passwordDescriptor;

        @Override
        public String getUsernamePropertyDescriptor() {
            return (String)Preconditions.checkNotNull((Object)this.usernameDescriptor);
        }

        @Override
        public String getPasswordPropertyDescriptor() {
            return (String)Preconditions.checkNotNull((Object)this.passwordDescriptor);
        }

        @Override
        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Override
        @Nullable
        public String getPassword() {
            return this.password;
        }

        @VisibleForTesting
        void setUsername(String username) {
            this.username = username;
        }

        @VisibleForTesting
        void setPassword(String password) {
            this.password = password;
        }

        private void setPropertyDescriptors(String descriptorPrefix) {
            this.usernameDescriptor = descriptorPrefix + "<username>";
            this.passwordDescriptor = descriptorPrefix + "<password>";
        }
    }
}

